.MODEL LARGE

.CODE

SQRS	DW	0,1,4,9,16,25,36,49,64,81,100,121,144,169,196,225,256
	DW	289,324,361,400,441,484,529,576,625,676,729,784,841,900
	DW	961,1024,1089,1156,1225,1296,1369,1444,1521,1600,1681
	DW	1764,1849,1936,2025,2116,2209,2304,2401,2500,2601,2704
	DW	2809,2916,3025,3136,3249,3364,3481,3600,3721,3844,3969
	DW	4096,4225,4356,4489,4624,4761,4900,5041,5184,5329,5476
	DW	5625,5776,5929,6084,6241,6400,6561,6724,6889,7056,7225
	DW	7396,7569,7744,7921,8100,8281,8464,8649,8836,9025,9216
	DW	9409,9604,9801,10000,10201,10404,10609,10816,11025
	DW	11236,11449,11664,11881,12100,12321,12544,12769,12996
	DW	13225,13456,13689,13924,14161,14400,14641,14884,15129
	DW	15376,15625,15876,16129,16384,16641,16900,17161,17424
	DW	17689,17956,18225,18496,18769,19044,19321,19600,19881
	DW	20164,20449,20736,21025,21316,21609,21904,22201,22500
	DW	22801,23104,23409,23716,24025,24336,24649,24964,25281
	DW	25600,25921,26244,26569,26896,27225,27556,27889,28224
	DW	28561,28900,29241,29584,29929,30276,30625,30976,31329
	DW	31684,32041,32400,32761,33124,33489,33856,34225,34596
	DW	34969,35344,35721,36100,36481,36864,37249,37636,38025
	DW	38416,38809,39204,39601,40000,40401,40804,41209,41616
	DW	42025,42436,42849,43264,43681,44100,44521,44944,45369
	DW	45796,46225,46656,47089,47524,47961,48400,48841,49284
	DW	49729,50176,50625,51076,51529,51984,52441,52900,53361
	DW	53824,54289,54756,55225,55696,56169,56644,57121,57600
	DW	58081,58564,59049,59536,60025,60516,61009,61504,62001
	DW	62500,63001,63504,64009,64516,65025

	PUBLIC	_SearchArray

; Register usage in SearchArray:
;	AX		Scratch
;	BH/CH/CL	Query color
;	BL		Nearest index
;
;	DX:DI		DX:DI is current distance

ARRAY	EQU	dword ptr [bp+6]
QUERY	EQU	dword ptr [bp+10]
NUM	EQU	word ptr [bp+14]

_SearchArray	PROC
	push	bp		; Establish stack frame
	mov	bp,sp		;
	sub	sp,8		; Allocate locals
	push	ds		; Save registers
	push	si		;
	push	di		;

	mov	ax,8000h	; Set ndist to a large number
	mov	[bp-2],ax	;
	mov	[bp-4],ax	;
	xor	ax,ax		; Set passback to 0
	mov	[bp-6],ax	; Set passback to nil
	mov	[bp-8],ax	;
	lds	si,ARRAY	; DS:SI <- array
	les	di,QUERY	; ES:DI <- query
	mov	bx,es:[di]	; BH <- query.clr.r
	mov	cx,es:[di+2]	; CH <- query.clr.b; CL <- query.clr.g
	xchg	ax,bx		; AH <- query.clr.r
DoWhile:
	xor	dx,dx		; Zero DX:DI
	xor	di,di		;
	inc	si		; Increment past the index
	xor	bx,bx		; Clear for promotion
	mov	bl,[si] 	; BL <- array[i].clr.r
	inc	si		;
	sub	bl,ah		; BL <- difference
	jz	ZeroR		; R zero
	ja	AbsR		;
	neg	bl		;
AbsR:	shl	bx,1
	mov	bx,SQRS[bx]

	mov	di,bx		; DX:DI <- diff.r ^ 2
	xor	dx,dx		;
ZeroR:	xor	bx,bx		; Clear for promotion
	mov	bl,[si] 	; BL <- array[i].clr.g
	inc	si		;
	sub	bl,cl		; BL <- difference
	jz	ZeroG		;
	ja	AbsG		;
	neg	bl		;
AbsG:	shl	bx,1		; BX <- diff.g ^ 2
	mov	bx,SQRS[bx]	;
	add	di,bx		; DX:DI += diff.g ^ 2
	adc	dx,0		;
ZeroG:	xor	bx,bx		; Clear for promotion
	mov	bl,[si] 	; BL <- array[i].clr.b
	inc	si		;
	sub	bl,ch		; BL <- difference
	jz	ZeroB		;
	ja	AbsB		;
	neg	bl		;
AbsB:	shl	bx,1		;
	mov	bx,SQRS[bx]	;
	add	di,bx		; DX:DI += diff.b ^ 2
	adc	dx,0		;
ZeroB:	cmp	dx,word ptr [bp-2] ; If DX:DI < ndist,
	ja	CheckWhile	; ndist = DX:DI
	jb	Smaller
	cmp	di,word ptr [bp-4]
	jae	CheckWhile
Smaller:
	mov	word ptr [bp-2],dx ; ndist <- temp
	mov	word ptr [bp-4],di ;
	lea	bx,[si-4]	   ; Save pointer
	mov	word ptr [bp-6],ds ;
	mov	word ptr [bp-8],bx ;
	or	dx,di		; If the distance just computed
	jz	DoneWhile	; was zero, we're done
CheckWhile:
	dec	NUM		; Decrement NUM
	jnz	short DoWhile	; Loop until done
DoneWhile:
	mov	ax,[bp-8]	; Get return value
	mov	dx,[bp-6]	;

	pop	di		; Restore registers
	pop	si		;
	pop	ds		;
	mov	sp,bp		; Deallocate locals
	pop	bp		; Restore stack frame
	ret			; Return
_SearchArray	ENDP

	PUBLIC	_Dist

_Dist	PROC
	push	bp		; Establish stack frame
	mov	bp,sp		;

	les	bx,[bp+6]	; Get a
	mov	ax,es:[bx]	; AH <- a.clr.r
	mov	cx,es:[bx+2]	; CH <- a.clr.b; CL <- a.clr.g
	les	bx,[bp+10]	; Get b
	mov	dx,es:[bx]	; DH <- b.clr.r
	mov	bx,es:[bx+2]	; BH <- b.clr.b; BL <- b.clr.g
	sub	ah,dh		; AH <- a.clr.r - b.clr.r
	ja	AbsRDist	;
	neg	ah		;
AbsRDist:
	sub	ch,bh		; CH <- a.clr.b - b.clr.b
	ja	AbsBDist	;
	neg	ch		;
AbsBDist:
	sub	cl,bl		; CL <- a.clr.g - b.clr.g
	ja	AbsGDist	;
	neg	cl		;
AbsGDist:
	xor	bx,bx		; Clear for promotion
	mov	bl,ah		;
	shl	bx,1		;
	mov	ax,SQRS[bx]	; DX:AX <- DIFFR^2
	xor	dx,dx		; Clear upper word of return value

	xor	bx,bx		; Clear for promotion
	mov	bl,ch		;
	shl	bx,1		;
	add	ax,SQRS[bx]	;
	adc	dx,0		; DX:AX += DIFFB^2

	xor	bx,bx		; Clear for promotion
	mov	bl,cl		;
	shl	bx,1		;
	add	ax,SQRS[bx]	;
	adc	dx,0		;

	pop	bp		; Restore stack frame
	ret			; Return
_Dist	ENDP

	PUBLIC	_Clip255

_Clip255 PROC
	mov	ax,[bp+6]
	cmp	ax,255
	jna	LeaveClip255
	jl	ZeroClip255
	mov	ax,255
	jmp	short LeaveClip255
ZeroClip255:
	xor	ax,ax
LeaveClip255:
	ret
_Clip255 ENDP

CLIP255 MACRO	A
	LOCAL	@1,@2
	cmp	A,255
	jna	@2
	js	@1
	mov	A,255
	jmp	short @2
@1:	xor	A,A
@2:
	ENDM

	PUBLIC	_DitherClr

_DitherClr	PROC
	push	bp		; Establish stack frame
	mov	bp,sp		;
	push	ds		; Save registers
	push	si		;
	push	di		;

	lds	si,[bp+6]	; Get pointer to color
	inc	si		; Point at r
	les	bx,[bp+10]	; Get pointer to error
	mov	dx,[bp+14]	; Get width

	xor	ax,ax		; Clear for promotion
	mov	cx,es:[bx]	; Get currerr[inx]
	sar	cx,1		; Div by 8
	sar	cx,1		;
	sar	cx,1		;
	jz	DoneRed 	; If dither value is 0, continue
	mov	al,[si] 	; Get clr.r
	add	ax,cx		; Dither
	CLIP255 ax		; Clip against 255
	mov	[si],al 	;

	xor	ax,ax		; Clear for promotion
DoneRed:
	inc	si		; Point at g
	add	bx,dx		; Point at error

	mov	cx,es:[bx]	; Get currerr[inx+width]
	sar	cx,1		; Div by 8
	sar	cx,1		;
	sar	cx,1		;
	jz	DoneGreen	; Jump if dither is 0
	mov	al,[si] 	; Get clr.g
	add	ax,cx		; Dither
	CLIP255 ax		; Clip against 255
	mov	[si],al 	; Save result
	xor	ax,ax		; Clear for promotion
DoneGreen:
	inc	si		; Point at b
	add	bx,dx		; Point at error
	mov	cx,es:[bx]	; Get currerr[inx+width+width]
	sar	cx,1		; Div by 8
	sar	cx,1		;
	sar	cx,1		;
	jz	DoneAll 	; Jump if dither is 0
	mov	al,[si] 	; Get clr.b
	add	ax,cx		; Dither
	CLIP255 ax		; Clip against 255
	mov	[si],al 	; Save result
DoneAll:
	pop	di		; Restore registers
	pop	si		;
	pop	ds		;
	pop	bp		;
	ret			;
_DitherClr	ENDP

R0	EQU	word ptr [bp-2]
R8	EQU	word ptr [bp-4]
G0	EQU	word ptr [bp-6]
G8	EQU	word ptr [bp-8]
B0	EQU	word ptr [bp-10]
B8	EQU	word ptr [bp-12]
MINR	EQU	byte ptr [bp-13]
MING	EQU	byte ptr [bp-14]
MINB	EQU	byte ptr [bp-15]
QUERYR	EQU	byte ptr [bp-16]
QUERYG	EQU	byte ptr [bp-17]
QUERYB	EQU	byte ptr [bp-18]

	PUBLIC	_IsNearCell

; Assume MSW:LSW contains a distance; exit CheckCorner (by jumping to
; LeaveCornerCheck) if MSW:LSW < r (the dword parameter at bp+14).
RCOMPARE	MACRO	MSW,LSW
	LOCAL	@1,@2,@3
	cmp	MSW,[bp+16]	;; Check against big half
	ja	@1		;; If MSW:LSW > r, continue
	je	@2		;; If equal, need to check lower half
	mov	ax,1		;; Return 1 if MSW:LSW < r
	jmp	LeaveCornerCheck
@2:	cmp	LSW,[bp+14]	;; Check against little half
	ja	@1		;; If MSW:LSW >  r, continue
@3:	mov	ax,1		;; Otherwise return 1
	jmp	LeaveCornerCheck
@1:
	ENDM

; A is an 8-bit register.  B is a memory location or register.
; DIFFSQ replaces AX by the square of (A - B).
; DIFFSQ stomps BX and AX, and stomps the register A.
DIFFSQ	MACRO	A,B
	LOCAL	@1
	sub	A,B		;; A -= B
	ja	@1		;; Take absolute value
	neg	A		;;
@1:	xor	bx,bx		;; AX <- square(A - B)
	mov	bl,A		;;
	shl	bx,1		;;
	mov	ax,SQRS[bx]	;;
	ENDM

_IsNearCell	PROC
	push	bp		; Establish stack frame
	mov	bp,sp		;
	sub	sp,18		; Allocate locals
	push	si		; Save regs
	push	di		;

	les	bx,[bp+6]	; Get pointer to min
	mov	ax,es:[bx]	; AH <- min.clr.r
	mov	cx,es:[bx+2]	; CH <- min.clr.b; CL <- min.clr.g
	sub	ah,4		; min -= (4, 4, 4)
	sub	ch,4		;
	sub	cl,4		;
	mov	MINR,ah 	; Copy to locals
	mov	MING,cl 	;
	mov	MINB,ch 	;

	les	bx,[bp+10]	; Get pointer to query
	mov	ax,es:[bx]	; AH <- query.clr.r
	mov	cx,es:[bx+2]	; CH <- query.clr.b; CL <- query.clr.g
	mov	QUERYR,ah	; Copy to locals
	mov	QUERYG,cl	;
	mov	QUERYB,ch	;

	DIFFSQ	ah,MINR 	; AX <- sqr(MINR - QUERYR)
	mov	R0,ax		; Save in R0
	xchg	ax,si		; Save in SI
	DIFFSQ	cl,MING 	; AX <- sqr(MING - QUERYG)
	mov	G0,ax		; Save in G0
	xchg	ax,di		; Save in DI
	DIFFSQ	ch,MINB 	; AX <- sqr(MINB - QUERYB)
	mov	B0,ax		;
	xor	dx,dx		; DX:AX <- sum(R0+G0+B0)
	add	ax,si		;
	adc	dx,0		;
	add	ax,di		;
	adc	dx,0		;
	RCOMPARE dx,ax		; 000

	sub	ax,B0		; Subtract blue component out
	sbb	dx,0		;
	xchg	ax,cx		; Get LSW into CX

	xor	ax,ax		; Clear for promotion
	mov	al,MINB 	; Get min.b
	add	ax,8		; AX <- min.b + 8
	DIFFSQ	al,QUERYB	; AX <- sqr(min.b+8 - query.b)
	mov	B8,ax		; Save into B8
	add	cx,ax		; DX:CX += AX
	adc	dx,0		;
	RCOMPARE dx,cx		; 008

	sub	cx,G0		; Subtract green component out
	sbb	dx,0		;
	xor	ax,ax		; Clear for promotion
	mov	al,MING 	; Get min.g
	add	ax,8		; AX <- min.g + 8
	DIFFSQ	al,QUERYG	; AX <- sqr(min.g+8 - query.g)
	mov	G8,ax		; Save into G8
	add	cx,ax		; DX:CX += AX
	adc	dx,0		;
	RCOMPARE dx,cx		; 088

	sub	cx,B8		; DX:AX -= B8
	sbb	dx,0		;
	add	cx,B0		; DX:AX += B0
	adc	dx,0		;
	RCOMPARE dx,cx		; 080

	sub	cx,R0		; DX:AX -= R0
	sbb	dx,0		;
	xor	ax,ax		; Clear for promotion
	mov	al,MINR 	; Get min.r
	add	ax,8		; AX <- min.r + 8
	DIFFSQ	al,QUERYR	; AX <- sqr(min.r+8 - query.r)
	mov	R8,ax		; Save into R8
	add	cx,ax		; DX:CX += R8
	adc	dx,0		;
	RCOMPARE dx,cx		; 880

	sub	cx,B0		; DX:CX -= B0
	sbb	dx,0		;
	add	cx,B8		; DX:CX += B8
	adc	dx,0		;
	RCOMPARE dx,cx		; 888

	sub	cx,G8		; DX:CX -= G8
	sbb	dx,0		;
	add	cx,G0		; DX:CX += G0
	adc	dx,0		;
	RCOMPARE dx,cx		; 808

	sub	cx,B8		; DX:CX -= B8
	sbb	dx,0		;
	add	cx,B0		; DX:CX += B0
	adc	dx,0		;
	RCOMPARE dx,cx		; 800

	xor	ax,ax		; Return 0 if reach here
LeaveCornerCheck:
	pop	di		; Restore regs
	pop	si		;
	mov	sp,bp		;
	pop	bp		; Restore stack frame
	ret			; Return
_IsNearCell	ENDP

	END
