#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include "hist.h"
#include "lsearch.h"
#include "image.h"

extern int red[256], green[256], blue[256];
void GIFEncode( FILE *fp,
		int GWidth,
		int GHeight,
		int GInterlace,
		int Background,
		int BitsPerPixel,
		int *Red,
		int *Green,
		int *Blue,
		Image *img);

extern "C" unsigned char Clip255(int temp);
extern "C" void DitherClr(Color *, int *, int);

Image::Image(char *newfile, int dither)
{
  unsigned char *local;
  unsigned char c, d;
  ifstream inpf;

  strcpy(filename, newfile);
  inpf.open(filename, ios::nocreate | ios::binary);
  if (! inpf) {
    cerr << "Could not open " << newfile << '\n';
    exit(1);
  }
  c = inpf.get();
  d = inpf.get();
  width = (d << 8) | c;
  c = inpf.get();
  d = inpf.get();
  height = (d << 8) | c;
  dithering = dither;
  inpf.close();
}

Image::~Image()
{
}

void Image::HistImage(Histogram& hist)
{
  unsigned char *local;
  unsigned char *localr, *localg, *localb;
  int x, y;
  int tempy;
  unsigned char c, d;
  int hand;
  int blksize = 3 * width + 2;

  local = new unsigned char[blksize];
  if (! local) {
    cerr << "Could not allocate local buffer in HistImage\n";
    exit(-1);
  }
  hand = open(filename, O_RDONLY | O_BINARY);
  _read(hand, local, 4);	// Skip over width and height
  for (y = 0; y < height; y++) {
    if (_read(hand, local, blksize) == -1) {
	cerr << "Error reading file.\n";
	exit(2);
    }
    tempy = (local[1] << 8) | local[0];
    if (tempy != y) {
      cerr << "Bad input file.\n";
      exit(1);
    }
    localr = local+2;
    localg = localr+width;
    localb = localg+width;
    for (x = 0; x < width; x++, localr++, localg++, localb++)
      hist.IncElement(*localr >> 3, *localg >> 3, *localb >> 3);
  }
  close(hand);
  delete local;
}

void Image::ReadImage(void (*func)(int, unsigned char *, unsigned char *, unsigned char *, int))
{
  unsigned char *local;
  int x, y;
  int tempy;
  int inpf;
  unsigned char c, d;

  local = new unsigned char[width * 3 + 2];
  if (! local) {
    cerr << "Could not allocate local buffer in ReadImage\n";
    exit(-1);
  }

  inpf = open(filename, O_RDONLY | O_BINARY);
  _read(inpf, local, 4);	// Skip over width and height
  for (y = 0; y < height; y++) {
    _read(inpf, local, width * 3 + 2);
    (*func)(y, local + 2,
	    local + width + 2,
	    local + width + width + 2,
	    width);
  }
  close(inpf);

  delete local;
}

static int inpf;

void Image::GearForGetPixel(LocalSearch *LSearch, Color& clr)
{
  char local[4];
  scanline = new unsigned char[3*width + 2];
  inpf = open(filename, O_RDONLY | O_BINARY);
  _read(inpf, local, 4);
  _read(inpf, scanline, width * 3 + 2);
  inx = 2;
  if (dithering) {
    err[0] = (int *) malloc((width * 3 + 2) * sizeof(int));
    err[1] = (int *) malloc((width * 3 + 2) * sizeof(int));
    memset(err[0], 0, (width * 3 + 2) * sizeof(int));
    memset(err[1], 0, (width * 3 + 2) * sizeof(int));
    currerr = err[0];
    nexterr = err[1];
  }
  locsearch = LSearch;
  lastnearest = clr;
}

int Image::GetPixel(int x, int y)
{
  Color *nearest;
  Color query;

  if (inx == width+2) {
    _read(inpf, scanline, width * 3 + 2);
    inx = 2;
    if (dithering) {
      int *temp;
      memset(currerr, 0, (width * 3 + 2) * sizeof(int));
      temp = currerr;
      currerr = nexterr;
      nexterr = temp;
    }
  }

  query = Color(scanline[inx], scanline[inx+width], scanline[inx+width+width]);
  if (dithering) {
    DitherClr(&query, currerr+inx, width);
//  query.clr.r = Clip255((int) query.clr.r + (currerr[inx] >> 3));
//  query.clr.g = Clip255((int) query.clr.g + (currerr[inx+width] >> 3));
//  query.clr.b = Clip255((int) query.clr.b + (currerr[inx+width+width] >> 3));
  }
  else if (query == lastnearest) {
    inx++;
    return lastnearest.inx;
  }
  nearest = locsearch->FindNearest(query);
  if (dithering) {
    int rerr, gerr, berr;
    rerr = (int) query.clr.r - nearest->clr.r;
    if (rerr) {
      currerr[inx+1] += 3 * rerr;
      nexterr[inx] += 3 * rerr;
      nexterr[inx+1] += 2 * rerr;
    }
    gerr = (int) query.clr.g - nearest->clr.g;
    if (gerr) {
      currerr[inx+width+1] += 3 * gerr;
      nexterr[inx+width] += 3 * gerr;
      nexterr[inx+width+1] += 2 * gerr;
    }
    berr = (int) query.clr.b - nearest->clr.b;
    if (berr) {
      currerr[inx+width+width+1] += 3 * berr;
      nexterr[inx+width+width] += 3 * berr;
      nexterr[inx+width+width+1] += 2 * berr;
    }
  }
  else
    lastnearest = *nearest;
  inx++;
  return nearest->inx;
}

void Image::MapToGIF(FILE *out, int num_clrs)
{
  int num_lvls = 0;
  switch (num_clrs) {
    case 256:	num_lvls++;
    case 128:	num_lvls++;
    case 64:	num_lvls++;
    case 32:	num_lvls++;
    case 16:	num_lvls++;
    case 8:	num_lvls++;
    case 4:	num_lvls++;
    case 2:	num_lvls++;
      break;
    default:
      cerr << "Number of colors must be a power of 2.\n";
      exit(2);
  }
  GIFEncode(out, width, height, 0, 0, num_lvls, red, green, blue, this);
}

void Image::StopGetPixel()
{
  delete scanline;
  close(inpf);
}
