// lsearch.h: header file for locally sorted search library
// Copyright (C) 1991 by Nicholas Wilt.  All rights reserved.

struct Color {
  unsigned char inx;
  union {
    unsigned char clrs[3];
    struct {
      unsigned char r, g, b;
    } clr;
  };
public:
  inline Color() {}
  inline Color(unsigned char Inx,
	       unsigned char R, unsigned char G, unsigned char B)
    { inx = Inx; clr.r = R; clr.g = G; clr.b = B; }
  inline Color(unsigned char R, unsigned char G, unsigned char B)
    { clr.r = R; clr.g = G; clr.b = B; }
  inline Color(int R, int G, int B)
    { if (R < 0) clr.r = 0; else if (R > 255) clr.r = 255; else clr.r = R;
      if (G < 0) clr.g = 0; else if (G > 255) clr.g = 255; else clr.g = G;
      if (B < 0) clr.b = 0; else if (B > 255) clr.b = 255; else clr.b = B;
    }
  inline unsigned char GetElm(int which)
    { return clrs[which]; }
  inline void SetElm(int which, unsigned char val)
    { clrs[which] = val; }
  friend int operator== (Color& A, Color& B);
//friend long Dist(Color& a, Color& b);
};

inline int operator== (Color& A, Color& B)
{
  return A.clr.r == B.clr.r &&
	 A.clr.g == B.clr.g &&
	 A.clr.b == B.clr.b;
}

class LocalSearch {
private:
  Color ****list;
  unsigned char *cnts;
  Color *clrs;
  int numclrs;

void ComputeSquares();
void FindColorList(Color& query);

public:
  LocalSearch(Color *NewClrs, int NumClrs);
  Color *FindNearest(Color& query);
};
