#include <bios.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include "async.h"

void dumbterm ( ASYNC *port) ;

void main ( void)
{
    ASYNC *com ;
   //
   // Open COM1 at 2400 baud for no parity, 8 data bits, 1 stop bit, using
   // a 4096-byte input buffer and a 500 byte output buffer.
   //
   com = AS_open ( 1, 2400, PAR_NONE, 8, 1, 4096, 500) ;
   if ( !com)
    {
       cputs ( "Cannot open COM port.\r\n") ;
       exit ( 5) ;
    }

   dumbterm ( com) ; // do it.

   //
   // Close COM port. (Never forget to do this.)
   //
   AS_close ( com, 0) ;
} // end of main()

void dumbterm ( ASYNC *port)
{
    int ch, x, y ;
 //
 // Give the user some last-minute instructions.
 //
    cputs("Terminal mode active, ALT-X to exit.\r\n");
    //
    // Keep acting like a (!DUMB!) terminal until Alt-X is pressed.
    //
    do
     { // If a key has been pressed, read it from the keyboard.
	 if ( bioskey ( 1))
	   ch = bioskey ( 0) ;
	 else
	   ch = 0 ;
	 // If Alt-X was pressed, leave this loop.
	 if ( ch == 0x2d00)
	   break ;
	 // If a key was pressed, the scan code off of ch and transmit it.
	 ch &= 0xff ;
	 if ( ch)
	   AS_putc ( ch, port) ;

	 // If a character has been received, display it.
	 ch = AS_getc ( port) ;
	 if ( ch != -1)
	   switch ( ch)
	   {
	      case 0 : // Ignore null characters.
		break ;
	      case 7 : // Beep for bell characters.
		  printf ( "%c", 7) ;
		break ;
	      case 8 : // Do back spaces manually.
		x = wherex() - 1 ;
		y = wherey() ;
		if ( x < 1)
		 {
		   x = 80 ;
		   y-- ;
		   if ( y < 1)
		     x = y = 1 ;
		 }
		gotoxy ( x, y) ;
		putch ( ' ') ;
		gotoxy ( x, y) ;
		break ;
	      case '\n' : // Ignore linefeeds.
		break ;
	      case '\r' : // Treat cr's as cr/lf's.
		cputs ( "\r\n") ;
		break ;

	      default :
		putch ( ch) ;
	      break ;
	   }
     } while ( 1) ;
}
