
/*
 * Help file internal format header file
 * Written by [Name removed by Pete Davis at authors request]
 * Based on help file hex dumps,
 *  and help file documentation from Pete Davis <HJ647C@gwuvm.gwu.edu>
 */

typedef unsigned long	DWORD;
typedef unsigned int	WORD;
typedef unsigned char	BYTE;
typedef long		LONG;
typedef	int		INT;
typedef char		CHAR;

typedef unsigned long	PDATA;


//----------------------------------------------------------------------
//General help header structure
//----------------------------------------------------------------------

typedef struct {
  DWORD	dwMagic;		//Magic number = 0x00035F3F
  PDATA pDirectory;		//Pointer to internal file system info
  DWORD dwReservedFF;		//Reserved, 0xFFFFFFFF
  DWORD dwFileSize;		//Size of entire file
  } HELPHEADER;


//----------------------------------------------------------------------
//Generic internal file header structure.
//This structure used for all internal files.
//----------------------------------------------------------------------

typedef struct {
  DWORD dwOverallSize;	//Size of internal file, including header
  DWORD dwFileSize;		//Size of internal file, excluding header
  BYTE bReserved0;		//Always 0
  } FILEHEADER;


//----------------------------------------------------------------------
//Help internal file system header structure
//  This is pointed to by the pDirectory member of the HELPHEADER structure
//
//The internal file system consists of:
//
//
//	a FILESYSTEMHEADER structure, followed by a b-tree that consists
//	of one or more 2K pages.
//
//	Each 2K page consists of either internal nodes or leaf nodes in
//	the B-tree.
//
//	A page of internal nodes consists of a IFSBTREENODEPAGEHEADER,
//	followed by a number of node records, each of which consists of
//	alternating acisz filename, and word page number.  In a page
//	with n items, there are n file names and n+1 page numbers.  For
//	example, in a page with 2 entries, you'd have:
//
//		IFSBTREENODEPAGEHEADER
//		page0
//		asciz0
//		page1
//		asciz1
//		page2
//	where asciz0 is the name of the first file on page1, and asciz1
//	is the name of the first file on page2.
//
//	To search the B-tree, compare the desired filename with asciz0.
//	If it is <, goto page0; otherwise compare with asciz1.  If less,
//	goto page1 else goto page2
//
//	To traverse the B-tree, recurse through page0, page1, ..., pagen+1
//	in order.  The pages may be further nodes or leafs, depending on the
//	level.
//
//	A page of leaf nodes consists of a IFSBTREELEAFPAGEHEADER,
//	followed by a number of leaf records, each of which consists of
//	an asciz filename and a dword pointer to the file.
//
//----------------------------------------------------------------------

typedef struct {
  DWORD dwSectionSize;	//Size of this section
  DWORD dwUnknown00;		//Unknown -- seems to be dwSectionSize-9

  BYTE bUnknown00[23];
  WORD wReserved0;		//Always 0
  WORD wNoSplits;		//Number of splits in B-Tree
  WORD wRootPage;		//Page number of root page
  WORD wReserved1;		//Always FFFF
  WORD wTotalPages;		//Total # of 2K pages
  WORD wNoLevels;		//# of levels in B-Tree
  DWORD dwNoEntries;		//# of entries in B-Tree
  } FILESYSTEMHEADER;

typedef struct {
  WORD wSignature;		//Signature
  WORD wNoEntries;		//# of entries in this page
  } IFSBTREENODEPAGEHEADER;

typedef struct {
  WORD wSignature;		//Reserved signature?
  WORD wNoEntries;		//# of entries
  WORD wPrevPage;		//Previous page
  WORD wNextPage;		//Next page
  } IFSBTREELEAFPAGEHEADER;


//----------------------------------------------------------------------
// SYSTEM file format
//  This defines parameters for the help file.
//  It consist of
//	a SYSTEMFILE structure, followed by
//	multiple SYSTEMDATA records.
//	Each SYSTEMDATA record is immediately followed by the
//	data, or by a pointer to the data (depending on data type)
//----------------------------------------------------------------------

typedef struct {
  BYTE bReserved6C;		//Reserved "magic" number == 6C
  BYTE bVersion;		//Version number
  BYTE bRevision;		//Revision number
  BYTE bReserved0;		//Always 0
  WORD wReserved1;		//Always 1
  DWORD dwDateTime;		//Date/Time stamp
  WORD wCompressionFlag;	//Compression flag
  } SYSTEMFILE;

typedef struct {
  WORD wTypeOfData;		//Type of data
  WORD wDataSize;		//Size of data
  } SYSTEMDATA;

//-- Define compression flags for SYSTEMFILE --

#define	HFLAG_UNCOMPRESSED	0x0000		//Uncompressed file
#define	HFLAG_COMPRESSMEDIUM	0x0004		//Medium compression
#define	HFLAG_COMPRESSHIGH	0x0008		//High compression

#define	HFLAG_SYSTEM		0x000A		//??

//-- Define data types for SYSTEMDATA record --

#define HDATATYPE_TITLE	0x0001		//Title from HPJ file
#define	HDATATYPE_COPYRIGHT	0x0002		//Copyright from HPJ file
#define	HDATATYPE_CONTENTS	0x0003		//Contents???
#define	HDATATYPE_MACRO	0x0004		//Macros
#define	HDATATYPE_ICON	0x0005		//Icon
#define	HDATATYPE_AUXWINDOW	0x0006		//Secondary window
#define	HDATATYPE_CITATION	0x0008		//Citation from HPJ file


//----------------------------------------------------------------------
//TOPIC file format
//----------------------------------------------------------------------

//-- Topic file header record ---

typedef struct {
  DWORD dwPrevRecord;		//Prev record (last rec in prev page)
  DWORD dwFirstRecord;		//First record (in this page)
  DWORD dwPrevTopic;            //Start of prev topic (1st rec of last topic
                                //      in prev page)
  } TOPICHEADER;

//-- Define generic topic record header structure --

typedef struct {
  DWORD dwRecordSize;			//Size of record
  DWORD dwDataSize;			//Size of data (after decompression
                                        // and phrase substitution).
  DWORD dwPrev;			        //Previous record pointer
  DWORD dwNext;			        //Next record pointer
  DWORD dwDataOffset;			//Offset to data
  BYTE bRecordType;			//Type of record
  } TOPICRECHEADER;

//-- Define record types --

#define	TOPICTITLEID	0x02		//Id for topic title type record
#define	TOPICDATAID	0x20		//Id for topic data type record
#define TOPICTABLEID    0x23            //Id for topic data table record

//-- Define structures for topic title record --

typedef struct {
  DWORD dwNextTopicOffset;		//Offset to next topic
  DWORD dwReserved1;			//Reserved
  DWORD dwReserved2;			//Reserved
  DWORD dwTopicId;			//Topic id
  DWORD dwTopicNonScroll;               //Pointer to non-scroll data
  DWORD dwTopicData;			//Pointer to topic data
  DWORD dwNextTopicPointer;		//Pointer to next topic
  } TOPICTITLERECHEADER;

//-- Define structures for type 0x20 and type 0x23 topic data record --


//-- Define paragraph attribute bits --

#define PAR_NONWRAP     0x10000000      //Non-wrapping text

#define PAR_JUSTCENTER  0x08000000      //Center justified
#define PAR_JUSTRIGHT   0x04000000      //Right justified

#define PAR_BORDERED    0x01000000      //Paragraph bordered

#define PAR_FIRSTINDENT 0x00400000      //First line indent
#define PAR_RIGHTINDENT 0x00200000      //Right margin indent
#define PAR_LEFTINDENT  0x00100000      //Left margin indent

#define PAR_LINESPACING 0x00080000      //Line spacing
#define PAR_SPACEAFTER  0x00040000      //Space after
#define PAR_SPACEBEFORE 0x00020000      //Space before


//-- Define segment attribute ids --

#define SEG_FONT	0x80		//Font change identifier
#define SEG_NEWLINE	0x81		//New line indicator
#define	SEG_PAR	        0x82		//New paragraph indicator
#define	SEG_TAB	        0x83		//Tab indicator
#define	SEG_ENDLINK	0x89		//End of hotlink
#define	SEG_POPLINK	0xE2		//Popup hot-link indicator
#define	SEG_HOTLINK	0xE3		//Hot link indicator
#define	SEG_END	        0xFF		//End of segment list

//-- Define border bytes --

#define BORDER_DOT      0x80            //Dotted border
#define BORDER_DOUBLE   0x40            //Double border
#define BORDER_THICK    0x20            //Thick border
#define BORDER_RIGHT    0x10            //Right border
#define BORDER_BOTTOM   0x08            //Bottom border
#define BORDER_LEFT     0x04            //Left border
#define BORDER_TOP      0x02            //Top border
#define BORDER_BOX      0x01            //Boxed border



//----------------------------------------------------------------------
//FONT file format
// The font file consists of the font information from the start of
// the RTF file.
// It consists of
//	the FONTHEADER structure, followed by
//	multiple FONTNAME structures, followed by
//	multiple FONTINFO structures.
//----------------------------------------------------------------------

typedef struct {
  WORD wNoFonts;			//# of fonts
  WORD wNoFontDescriptors;		//# of font descriptors
  WORD wDefaultDescriptor;		//Default font descriptor
  WORD wDescriptorTableOffset;		//Offset to descriptor table
  } FONTHEADER;

typedef struct {
  CHAR szFontName[20];			//Asciz font name in 20-char field
  } FONTNAME;

typedef struct {
  BYTE bAttributes;			//Font attributes
  BYTE bTwicePointSize;		//Point size * 2
  BYTE bFamily;			//Font family
  BYTE bNoFonts;			//# of fonts in font list
  BYTE bUnknown0;			//??
  BYTE bForegroundRGB[3];		//Foreground RGB
  BYTE bBackgroundRGB[3];		//Background RGB
  } FONTINFO;

//-- Define font attributes for bAttributes member of FONTINFO --

#define	FONT_NORMAL	0x00		//Normal font
#define	FONT_BOLD	0x01		//Boldface
#define	FONT_ITAL	0x02		//Italics
#define	FONT_UNDER	0x04		//Underline
#define	FONT_STRIKE	0x08		//Strikeout
#define	FONT_DBLUND	0x10		//Double underline
#define	FONT_SMALLCAPS	0x20		//Small caps

//-- Define font families for bFamily member of FONTINFO --

#define FAM_MODERN	0x01		//Modern
#define	FAM_ROMAN	0x02		//Roman
#define	FAM_SWISS	0x03		//Swiss (also Tech, Nil)
#define	FAM_SCRIPT	0x04		//Script
#define	FAM_DECOR	0x05		//Decor


//----------------------------------------------------------------------
//KWBTREE file structure
//
//The KWBTREE file contains the B-Tree for the keywords of the help file.
//The file is structured as
//
//	a KWBTREEHEADER structure, followed by a b-tree that consists
//      of one or more 2K pages.
//
//	Each 2K page consists of either internal nodes or leaf nodes in the
//	B-tree.
//
//	A page of internal nodes consists of a KWBTREENODEPAGEHEADER,
//	followed by a number of node records, each of which consists of
//	alternating ASCIZ search keywords, and word page number.  In a page
//	with n items, there are n ASCIZ strings and n+1 page numbers.  For
//	example, in a page with 2 entries, you'd have:
//
//		KWBTREENODEPAGEHEADER
//		page0
//		ASCIZ0
//		page1
//		ASCIZ1
//		page2
//
//
//	To search the B-tree, compare the desired keyword with ASCIZ0.
//	If it is <, goto page0; otherwise compare with ASCIZ1.  If less,
//	goto page1 else goto page2
//
//	To traverse the B-tree, recurse through page0, page1, ..., pagen+1
//	in order.  The pages may be further nodes or leafs, depending on the
//	level.
//
//	A page of leaf nodes consists of a KWBTREELEAFPAGEHEADER,
//	followed by a number of leaf records, each of which consists of
//	the ASCIZ keyword, followed by a word count of reference (wRefCount)
//	and a dword offset value (dwRefOffset), where wRefCount is the number
//	of times the keyword is used, and dwRefOffset is the offset in the
//	KWDATA subfile for the entries for that use, where each entry is a
//	long pointer to the topic that is refered to by the keyword.
//
//----------------------------------------------------------------------

typedef struct {
  BYTE bUnknown[22];			//Unknown contents
  WORD wReserved0;			//Always 0
  WORD wNoPageSplits;			//# of page splits
  WORD wRootPage;			//Page # of root
  WORD wReservedFFFF;			//Always FFFF
  WORD wNoPages;			//# of 2K pages in B-Tree
  WORD wLevels;			//# of levels in B-Tree
  DWORD dwTotalEntries;		//Total entries in B-Tree
  } KWBTREEHEADER;

typedef struct {
  WORD wSignature;			//Signature
  WORD wNoEntries;			//# of entries in this page
  } KWBTREENODEPAGEHEADER;

typedef struct {
  WORD wSignature;			//Signature
  WORD wNoEntries;			//# of entries in this page
  WORD wPrevPage;			//Previous page index
  WORD wNextPage;			//Next page index
  } KWBTREELEAFPAGEHEADER;

typedef struct {
  WORD wReserved;			//Reserved, 1
  DWORD dwLeafData;			//Dword leaf data
  } KWBTREELEAFNODE;


//----------------------------------------------------------------------
//KWDATA subfile
//
// The KWDATA subfile contains a simple table of DWORD values, each of
// which is a pointer into the TOPIC section for the topic that a particular
// keyword is refering to.  This table is used in conjunction with the
// information from the KWBTREE subfile, like so:
//
// A leaf node in the B-Tree consists of a number of leaf records.
// Each leaf record consists of the ASCIZ keyword itself, followed by
// a word value and a dword value.
// The word value is a count of the number of topics to which this
//  keyword refers (wRefCount).
// The dword value is the index into the KWDATA table of where the
//  references are stored (dwRefOffset).
//
// The topics for a particular keyword can be found by looking in the B-Tree
//  for the keyword, and getting the wRefCount and dwRefOffset values for
//  the keyword.  The pointers to the topics are stored in the KWDATA file
//  as entries dwRefOffset, dwRefOffset+1, ..., dwRefOffset+wRefCount-1
//
// For example, if the B-Tree entry is {"directories", 3, 15},
//  then there are three topics referenced, starting at the 15th entry
//  in the KWDATA file.  If the KWDATA file has been read into a table
//  named TopicPointers, then TopicPointers15, TopicPointers16 and
//  TopicPointers17 contain the pointers to the topics that are referenced
//  by the keyword "directories".
//
//----------------------------------------------------------------------

//----------------------------------------------------------------------
//KWMAP subfile
//
// The KWMAP file contains a simple list of leaf pages from the KWDATA
// file.  It is formatted as:
//
//	The number of entries in the file (i.e., number of leaf pages)
//	One entry per leaf table, each consisting of:
//	  The ordinal number of the 1st keyword on that page,
//	  The page number for that leaf.
//
// For example, the file containing:
//	0003 00000000 0000 0000004B 0001 0000009B 0002
// refers to a KWBTREE file that has 3 leaf pages, where
//  the first page is page 0 and starts with keyword #0,
//  the second page is page 1 and starts with keyword #4B,
//  the final page is page 2 and starts with keyword #9B.
// The KWBTREE file would have 4B keywords on page 0, 50 keywords on
//  page 2, and the remaining keywords on page 3.
//
// The data in this file can be used to traverse the tree quickly.
//
//----------------------------------------------------------------------


//----------------------------------------------------------------------
//TTLBTREE file structure
//
//The TTLBTREE file contains the B-Tree for the titles of the topics in
// the help file.
//
//The file is structured as
//
//	a TTLBTREEHEADER structure, followed by a b-tree that consists
//      of one or more 2K pages.
//
//	Each 2K page consists of either internal nodes or leaf nodes in the
//	B-tree.
//
//	A page of internal nodes consists of a TTLBTREENODEPAGEHEADER,
//	followed by a number of node records, each of which consists of
//	alternating dword topic id, and word page number.  In a page
//	with n items, there are n topic ids and n+1 page numbers.  For
//	example, in a page with 2 entries, you'd have:
//
//		TTLBTREENODEPAGEHEADER
//		page0
//		id0
//		page1
//		id1
//		page2
//	where id0 is the id of the topic that starts on page1, and id1
//	is the id of the first topic on page2.
//
//	To search the B-tree, compare the desired title with id0.
//	If it is <, goto page0; otherwise compare with id1.  If less,
//	goto page1 else goto page2
//
//	To traverse the B-tree, recurse through page0, page1, ..., pagen+1
//	in order.  The pages may be further nodes or leafs, depending on the
//	level.
//
//	A page of leaf nodes consists of a TTLBTREELEAFPAGEHEADER,
//	followed by a number of leaf records, each of which consists of
//	a dword value (topic index?), followed by the ASCIZ title.
//
//----------------------------------------------------------------------

typedef struct {
  BYTE bUnknown[22];			//Unknown contents
  WORD wReserved0;			//Always 0
  WORD wNoPageSplits;			//# of page splits
  WORD wRootPage;			//Page # of root
  WORD wReservedFFFF;			//Always FFFF
  WORD wNoPages;			//# of 2K pages in B-Tree
  WORD wLevels;			//# of levels in B-Tree
  DWORD dwTotalEntries;		//Total entries in B-Tree
  } TTLBTREEHEADER;

typedef struct {
  WORD wSignature;			//Signature
  WORD wNoEntries;			//# of entries in this page
  } TTLBTREENODEPAGEHEADER;

typedef struct {
  WORD wSignature;			//Signature
  WORD wNoEntries;			//# of entries in this page
  WORD wPrevPage;			//Previous page index
  WORD wNextPage;			//Next page index
  } TTLBTREELEAFPAGEHEADER;


//----------------------------------------------------------------------
//CTXOMAP subfile
//----------------------------------------------------------------------

typedef struct {
  DWORD dwTopicIndex;			//What is this used for?
  DWORD dwReserved[15];		//Unused
  } CTXOMAPHEADER;


//----------------------------------------------------------------------
//CONTEXT file structure
//
//The CONTEXT file contains the B-Tree for ?????
//
//The file is structured as
//
//	a CONTEXTBTREEHEADER structure, followed by a b-tree that consists
//      of one or more 2K pages.
//
//	Each 2K page consists of either internal nodes or leaf nodes in the
//	B-tree.
//
//	A page of internal nodes consists of a CONTEXTBTREENODEPAGEHEADER,
//	followed by a number of node records, each of which consists of
//	a hash value and topic offset tuple.
//
//	A page of leaf nodes consists of a CONTEXTBTREELEAFPAGEHEADER,
//	followed by a number of leaf records, each of which consists of
//	a CONTEXTBTREELEAFRECORD.
//
//----------------------------------------------------------------------

typedef struct {
  BYTE bUnknown[22];			//Unknown contents
  WORD wReserved0;			//Always 0
  WORD wNoPageSplits;			//# of page splits
  WORD wRootPage;			//Page # of root
  WORD wReservedFFFF;			//Always FFFF
  WORD wNoPages;			//# of 2K pages in B-Tree
  WORD wLevels;			//# of levels in B-Tree
  DWORD dwTotalEntries;		//Total entries in B-Tree
  } CONTEXTBTREEHEADER;

typedef struct {
  WORD wSignature;			//Signature
  WORD wNoEntries;			//# of entries in this page
  } CONTEXTBTREENODEPAGEHEADER;

typedef struct {
  WORD wSignature;			//Signature
  WORD wNoEntries;			//# of entries in this page
  WORD wPrevPage;			//Previous page index
  WORD wNextPage;			//Next page index
  } CONTEXTBTREELEAFPAGEHEADER;

typedef struct {
  DWORD dwHashValue;			//Hash value
  DWORD dwOffset;			//Offset value
  } CONTEXTBTREELEAFRECORD;





//----------------------------------------------------------------------
//Phrases subfile
//The Phrases subfile consists of the phrases used by the compression.
// It consists of:
//	the PHRASESHEADER structure, followed by
//	a long value indicating the desired size of the uncompressed
//	  phrases (used only if phrases are compressed), followed by
//	a table of phrase pointers (offsets to the phrases from the
//	  start of the table -- note that is 1 extra entry pointing to
//        the end of the phrases), followed by
//	the phrases themselves, which may be compressed.
//----------------------------------------------------------------------

typedef struct {
  WORD wPhraseCount;			//# of phrases in table
  WORD wReserved100;			//Reserved: 0x0100
  } PHRASESHEADER;


