/*** FILE "mapin.h" ************************************************ 130793 ***/
#ifndef _mapin_h_
#define _mapin_h_

#include "include/mapbase.h"

/*** Class hieracy ************************************************************/
/*

MapInBase -> ???

*/
/*** MapInBase ****************************************************************/

class MapInBase
{
public:
  enum Gravity
  { LowX    =0,
    CenterX =1,
    HighX   =2,
    CustomX =3,

    LowY    =0,
    CenterY =4,
    HighY   =8,
    CustomY =12,

    LowLow       =LowX   |LowY,
    LowCenter    =LowX   |CenterY,
    LowHigh      =LowX   |HighY,
    LowCustom    =LowX   |CustomY,
    CenterLow    =CenterX|LowY,
    CenterCenter =CenterX|CenterY,
    CenterHigh   =CenterX|HighY,
    CenterCustom =CenterX|CustomY,
    HighLow      =HighX  |LowY,
    HighCenter   =HighX  |CenterY,
    HighHigh     =HighX  |HighY,
    HighCustom   =HighX  |CustomY,
    CustomLow    =CustomX|LowY,
    CustomCenter =CustomX|CenterY,
    CustomHigh   =CustomX|HighY,
    CustomCustom =CustomX|CustomY,

    Left        =LowCenter,
    Right       =HighCenter,
    Top         =CenterLow,
    Buttom      =CenterHigh,
    TopLeft     =LowLow,
    TopRight    =HighLow,
    ButtomLeft  =LowHigh,
    ButtomRight =HighHigh,
    Center      =CenterCenter,
    Custom      =CustomCustom
  };

  virtual pix SizeX() const=0;  //Returns the dimensions of the read image.
  virtual pix SizeY() const=0;

  virtual double GetAspectRatio() const=0;  //Returns the pixel aspect ratio.

  virtual const char* GetComments() const=0;
  //Returns a pointer to a string containing all comments attached to the image.
  //Should end with '\0'.
};

#endif
/******** "mapin.h" ***********************************************************/

