
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1993
//------------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define USHORT unsigned short

typedef struct
{
    char name[20];
    unsigned short off;
    unsigned short ver;
    unsigned short id;
} VOCHEADER;

char gstring[80];
unsigned char ca;
unsigned short ra;
unsigned long la;
FILE *fp;

VOCHEADER v;
char dtype;
unsigned long dlen;
unsigned char tc;
unsigned char pt;
unsigned char md;
unsigned char min;
unsigned char max;

void main ( int argc, char *argv[] )
{
    if(argc==1)
    {
        printf(".VOC file not specified\n");
        exit(1);
    }
    strcpy(gstring,argv[1]);
    strcat(gstring,".VOC");
    if((fp=fopen(gstring,"rb"))==NULL)
    {
        strcpy(gstring,argv[1]);
        if((fp=fopen(gstring,"rb"))==NULL)
        {
            printf("Error opening .VOC file [%s]\n",argv[1]);
            exit(1);
        }
    }
    printf("FILE:  [%s]\n",gstring);
    fread(&v,1,sizeof(VOCHEADER),fp);
    for(ra=0;ra<19;ra++) gstring[ra]=v.name[ra]; gstring[ra]=0;
    if((strcmp(gstring,"Creative Voice File")!=0)||(v.name[ra]!=0x1A))
    {
        printf("Not a Creative Voice File (.VOC)\n");
        exit(1);
    }
    printf("Creative Voice File  V%u.%02u\n",(v.ver>>8)&0xFF,v.ver&0xFF);
    printf("Data starts at offset %08Xh\n",v.off);
    printf("Voice file identification code %04Xh, ",v.id);
    if((((~v.ver)+0x1234)&0xFFFF)==v.id) printf("passed\n");
    else printf("failed (ignored)\n");
    while(1)
    {
        if(fread(&dtype,1,1,fp)==0) break;
        dlen=0; fread(&dlen,1,3,fp);
        printf("\nBlock Type %u:  ",(USHORT)dtype);
        if(dtype==0)
        {
            printf("Terminator\n");
            break;
        }
        if(dtype==1)
        {
            printf("Voice Data\n");
            printf("Block Length %lu\n",dlen);
            fread(&tc,1,1,fp);
            printf("Time Constant %u, ",(USHORT)tc);
            ra=1000000L/(256L-tc);
            printf("%u Hz\n",ra);
            fread(&pt,1,1,fp);
            printf("Pack type %u:  ",(USHORT)pt);
            switch(pt)
            {
                case 0: printf("8 bit unpacked\n"); break;
                case 1: printf("4 bit packed\n"); break;
                case 2: printf("2.6 bit packed\n"); break;
                case 3: printf("2 bit packed\n"); break;
                case 4: printf("1 channel multi\n"); break;
                case 5: printf("2 channel multi\n"); break;
                case 6: printf("3 channel multi\n"); break;
                case 7: printf("4 channel multi\n"); break;
                case 8: printf("5 channel multi\n"); break;
                case 9: printf("6 channel multi\n"); break;
                case 10: printf("7 channel multi\n"); break;
                default: printf("Unknown\n"); break;
            }
            max=0x00;
            min=0xFF;
            for(la=2;la<dlen;la++)
            {
                fread(&ca,1,1,fp);
                if(ca>max) max=ca;
                if(ca<min) min=ca;
            }
            printf("Maximum %u, Minimum %u\n",(USHORT)max,(USHORT)min);
        }
        if(dtype==2)
        {
            printf("Voice Continuation\n");
            printf("Block Length %lu\n",dlen);
            max=0x00;
            min=0xFF;
            for(la=0;la<dlen;la++)
            {
                fread(&ca,1,1,fp);
                if(ca>max) max=ca;
                if(ca<min) min=ca;
            }
            printf("Maximum %u, Minimum %u\n",(USHORT)max,(USHORT)min);
        }
        if(dtype==3)
        {
            printf("Silence\n");
            printf("Block Length (always 3) %lu\n",dlen);
            fread(&ra,1,2,fp);
            printf("Period %u\n",ra);
            fread(&tc,1,1,fp);
            printf("Time Constant %u, ",(USHORT)tc);
            ra=1000000L/(256L-tc);
            printf("%u Hz\n",ra);
        }
        if(dtype==4)
        {
            printf("Marker");
            printf("Block Length %lu\n",dlen);
            fread(&ra,1,2,fp);
            printf("Marker value %u, %04Xh\n",ra,ra);
            if(dlen>2) fseek(fp,ftell(fp)+dlen-2,0);
        }
        if(dtype==5)
        {
            printf("ASCII Text\n");
            printf("Block Length %lu\n",dlen);
            la=dlen;
            while(la)
            {
                if(la>79) ca=79; else ca=la;
                la-=ca;
                fread(gstring,1,ca,fp); gstring[79]=0;
                printf("%s",gstring);
            }
        }
        if(dtype==6)
        {
            printf("Repeat Loop\n");
            printf("Block Length (always 2) %lu\n",dlen);
            fread(&ra,1,2,fp);
            printf("Count %u\n",ra);
        }
        if(dtype==7)
        {
            printf("End Repeat Loop\n");
            printf("Block Length (always 0) %lu\n",dlen);
        }
        if(dtype==8)
        {
            printf("Extended Block\n");
            printf("Block Length (always 4) %lu\n",dlen);
            fread(&ra,1,2,fp);
            printf("Time constant %u, ",ra);
            ra=256000000L/(65536L-ra);
            printf("%u Hz\n",ra);
            fread(&pt,1,1,fp);
            printf("Pack type %u:  ",(USHORT)pt);
            switch(pt)
            {
                case 0: printf("8 bit unpacked\n"); break;
                case 1: printf("4 bit packed\n"); break;
                case 2: printf("2.6 bit packed\n"); break;
                case 3: printf("2 bit packed\n"); break;
                case 4: printf("1 channel multi\n"); break;
                case 5: printf("2 channel multi\n"); break;
                case 6: printf("3 channel multi\n"); break;
                case 7: printf("4 channel multi\n"); break;
                case 8: printf("5 channel multi\n"); break;
                case 9: printf("6 channel multi\n"); break;
                case 10: printf("7 channel multi\n"); break;
                default: printf("Unknown\n"); break;
            }
            fread(&md,1,1,fp);
            printf("Mode %u, ",(USHORT)md);
            switch(md)
            {
                case 0: printf("mono\n"); break;
                case 1: printf("stereo\n"); break;
                default: printf("unknown\n"); break;
            }
        }
        if(dtype>8)
        {
            printf("UNKNOWN\n");
            printf("Block Length %lu\n",dlen);
            fseek(fp,ftell(fp)+dlen,0);
        }
    }
}
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1993
//------------------------------------------------------------------------------

