
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1993
//------------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

#include "..\sb.h"

unsigned char ca;
unsigned short ra;
unsigned long la;
FILE *fp;
unsigned char gstring[80];

// for .WAV stuff
unsigned long rID;
unsigned long rLen;
unsigned long wID;
unsigned long fID;
unsigned long fLen;
unsigned long fNext;
unsigned short wFormatTag;
unsigned short nChannels;
unsigned short nSamplesPerSec;
unsigned short nAvgBytesPerSec;
unsigned long dID;
unsigned long dLen;

void main ( int argc, char *argv[] )
{
    if(argc==1)
    {
        printf(".WAV file not specified\n");
        exit(1);
    }
    strcpy(gstring,argv[1]);
    strcat(gstring,".WAV");
    if((fp=fopen(gstring,"rb"))==0)
    {
        strcpy(gstring,argv[1]);
        if((fp=fopen(gstring,"rb"))==0)
        {
            printf("Error opening .WAV file [%s]\n",argv[1]);
            exit(1);
        }
    }
    printf("FILE: [%s]\n",gstring);
    sbsetup();
    fread(&rID,1,4,fp);
    if(rID!=0x46464952)
    {
        printf("Not a RIFF format file\n");
        exit(1);
    }
    fread(&rLen,1,4,fp);
    printf("rLen = %lu\n",rLen);
    fread(&wID,1,4,fp);
    if(wID!=0x45564157)
    {
        printf("Not a WAVE format chunk\n");
        exit(1);
    }
    fread(&fID,1,4,fp);
    if(fID!=0x20746D66)
    {
        printf("Not a fmt WAVE Format Chunk\n");
        exit(1);
    }
    fread(&fLen,1,4,fp);
    fNext=fLen+ftell(fp);
    printf("fLen %lu\n",fLen);
    printf("fNext %lu\n",fNext);
    fread(&wFormatTag,1,2,fp);
    if(wFormatTag!=1)
    {
        printf("Data is not PCM\n");
        exit(1);
    }
    fread(&nChannels,1,2,fp);
    if((nChannels!=1)&&(nChannels!=2))
    {
        printf("Must be MONO or STEREO data\n");
        exit(1);
    }
    if(nChannels==2)
    {
        printf("STEREO data will be half speed (twice as much data played mono)\n");
    }
    printf("nChannels %u\n",nChannels);
    fread(&nSamplesPerSec,1,2,fp);
    printf("nSamplesPerSec %u\n",nSamplesPerSec);
    fread(&nAvgBytesPerSec,1,2,fp);
    printf("nAvgBytesPerSec %u\n",nAvgBytesPerSec);
    fseek(fp,fNext,0);
    fread(&dID,1,4,fp);
    if(dID!=0x61746164)
    {
        printf("Not a DATA chunk\n");
        exit(1);
    }
    fread(&dLen,1,4,fp);
    printf("dLen %lu\n",dLen);
    ca=256UL-(1000000UL/nSamplesPerSec);
    printf("Time Constant %u\n",ca);
    sbsettc(ca);
    spkon();
    while(dLen)
    {
        if(dLen>65000) la=65000; else la=dLen;
        dLen-=la;
        fread(aligned,1,la,fp);
        sbplay(la);
        printf("%lu Samples\n",la);
        while(dmacount()!=0xFFFF)
        {
            if(kbhit())
            {
                sbhaltdma();
                getch();
                dLen=0;
                break;
            }
        }
    }
    spkoff();
}
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1993
//------------------------------------------------------------------------------

