/* MISCTEST.C */
/* Copyright 1990, 1991, 1992, 1993 Norman D. Culver Ft. Lauderdale, FL */
/*					All Rights Reserved 			  				    */

#include <stdlib.h>
#include "../cff.h"

#define PACKSIZE 100

void *h1;
void *h2;
void *h3;
void *h4;
void *h5;
void *h6;

static void print_dir(void *);
static void dir_test(void);
static void stat_test(void);
static void trn_test(void);

void
main()
{
	cfinit("misctest",1024,NULL);
	cfprintf("MISCTEST: TEST OF VARIOUS FUNCTIONS\n");

	h1 = cfopen("testfile.cff", F_RDWR|F_CREAT, NULL);
	cfdef("TESTFILE", "testfile.cff");
	if(h1 == NULL)
		cfprintf("Failed to create TESTFILE\n");

	h2 = cfopen("TESTFILE/object1", F_RDWR|F_CREAT, NULL);
	cfdef("OBJECT1", "TESTFILE/object1");
	if(h2 == NULL)
		cfprintf("Failed to create OBJECT1\n");

	h3 = cfopen("OBJECT1/object2", F_RDWR|F_CREAT|F_SORTED, NULL);
	cfdef("OBJECT2", "OBJECT1/object2");
	if(h3 == NULL)
		cfprintf("Failed to create OBJECT2\n");

	h4 = cfopen("OBJECT2/object3", F_RDWR|F_CREAT, NULL);
	cfdef("OBJECT3", "OBJECT2/object3");
	if(h4 == NULL)
		cfprintf("Failed to create OBJECT3\n");

	h5 = cfopen("OBJECT2/object4", F_RDWR|F_CREAT, NULL);
	cfdef("OBJECT4", "OBJECT2/object4");
	if(h5 == NULL)
		cfprintf("Failed to create OBJECT4\n");

	cfdef("PLAINFILE", "plnfile.xxx");
	h6 = cfopen("PLAINFILE", F_RDWR|F_CREAT, NULL);
	if(h6 == NULL)
		cfprintf("Failed to create PLAINFILE\n");


	trn_test();
	stat_test();
	dir_test();
	cfunlink("TESTFILE");
	cfunlink("PLAINFILE");

	cfexit();
} /* MAIN */

static void
trn_test()
{
char *newpath;
int type;

	cfprintf("\nNAME TRANSLATION TESTS\n");
	type = cfpathtrn(".", &newpath);
	cfprintf("%s becomes %s type=%d\n", ".", newpath, type);
	free(newpath);
	type = cfpathtrn("./xx.cff", &newpath);
	cfprintf("%s becomes %s type=%d\n", "./xx.cff", newpath, type);
	free(newpath);
	type = cfpathtrn("./xx.cff/abc/def", &newpath);
	cfprintf("%s becomes %s type=%d\n", "./xx.cff/abc/def", newpath, type);
	free(newpath);
	type = cfpathtrn("TESTFILE", &newpath);
	cfprintf("%s becomes %s type=%d\n", "TESTFILE", newpath, type);
	free(newpath);
	type = cfpathtrn("OBJECT1", &newpath);
	cfprintf("%s becomes %s type=%d\n", "OBJECT1", newpath, type);
	free(newpath);
	type = cfpathtrn("OBJECT2", &newpath);
	cfprintf("%s becomes %s type=%d\n", "OBJECT2", newpath, type);
	free(newpath);
	type = cfpathtrn("OBJECT3", &newpath);
	cfprintf("%s becomes %s type=%d\n", "OBJECT3", newpath, type);
	free(newpath);
	type = cfpathtrn("OBJECT4", &newpath);
	cfprintf("%s becomes %s type=%d\n", "OBJECT4", newpath, type);
	free(newpath);
	type = cfpathtrn("PLAINFILE", &newpath);
	cfprintf("%s becomes %s type=%d\n", "PLAINFILE", newpath, type);
	free(newpath);
}

static void
stat_test()
{
CFSTAT stats;

	cfprintf("\nSTAT TESTS\n");
	if(cfstat(".", &stats) == OK)
		cfprintf("mode of . = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of . failed\n");

	cfprintf("STAT FILES THAT ARE OPEN by name\n");
	if(cfstat("PLAINFILE", &stats) == OK)
		cfprintf("mode of PLAINFILE = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of PLAINFILE failed\n");

	if(cfstat("TESTFILE", &stats) == OK)
		cfprintf("mode of TESTFILE = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of TESTFILE failed\n");

	if(cfstat("OBJECT1", &stats) == OK)
		cfprintf("mode of OBJECT1 = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of OBJECT1 failed\n");

	if(cfstat("OBJECT2", &stats) == OK)
		cfprintf("mode of OBJECT2 = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of OBJECT2 failed\n");

	if(cfstat("OBJECT3", &stats) == OK)
		cfprintf("mode of OBJECT3 = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of OBJECT3 failed\n");

	if(cfstat("OBJECT4", &stats) == OK)
		cfprintf("mode of OBJECT4 = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of OBJECT4 failed\n");

	cfprintf("STAT FILES THAT ARE OPEN by handle\n");

	if(cfstat(h1, &stats) == OK)
		cfprintf("mode of h1 = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of h1 failed\n");

	if(cfstat(h2, &stats) == OK)
		cfprintf("mode of h2 = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of h2 failed\n");

	if(cfstat(h3, &stats) == OK)
		cfprintf("mode of h3 = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of h3 failed\n");

	if(cfstat(h4, &stats) == OK)
		cfprintf("mode of h4 = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of h4 failed\n");

	if(cfstat(h5, &stats) == OK)
		cfprintf("mode of h5 = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of h5 failed\n");

	if(cfstat(h6, &stats) == OK)
		cfprintf("mode of h6 = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of h6 failed\n");

	cfprintf("GET OBTYPE OF FILES THAT ARE OPEN by handle\n");
	cfprintf("obtype of h1 = %lx\n", cfobtype(h1));
	cfprintf("obtype of h2 = %lx\n", cfobtype(h2));
	cfprintf("obtype of h3 = %lx\n", cfobtype(h3));
	cfprintf("obtype of h4 = %lx\n", cfobtype(h4));
	cfprintf("obtype of h5 = %lx\n", cfobtype(h5));
	cfprintf("obtype of h6 = %lx\n", cfobtype(h6));

	cfprintf("GET OBTYPE OF FILES THAT ARE OPEN by name\n");
	cfprintf("obtype of TESTFILE = %lx\n", cfobtype("TESTFILE"));
	cfprintf("obtype of OBJECT1 = %lx\n", cfobtype("OBJECT1"));
	cfprintf("obtype of OBJECT2 = %lx\n", cfobtype("OBJECT2"));
	cfprintf("obtype of OBJECT3 = %lx\n", cfobtype("OBJECT3"));
	cfprintf("obtype of OBJECT4 = %lx\n", cfobtype("OBJECT4"));
	cfprintf("obtype of PLAINFILE = %lx\n", cfobtype("PLAINFILE"));



	cfprintf("CLOSE THE OPEN FILES\n");
	cfclose(h1);
	cfclose(h2);
	cfclose(h3);
	cfclose(h4);
	cfclose(h5);
	cfclose(h6);

	cfprintf("STAT FILES THAT ARE CLOSED by name\n");
	if(cfstat("PLAINFILE", &stats) == OK)
		cfprintf("mode of PLAINFILE = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of PLAINFILE failed\n");

	if(cfstat("TESTFILE", &stats) == OK)
		cfprintf("mode of TESTFILE = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of TESTFILE failed\n");

	if(cfstat("OBJECT1", &stats) == OK)
		cfprintf("mode of OBJECT1 = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of OBJECT1 failed\n");

	if(cfstat("OBJECT2", &stats) == OK)
		cfprintf("mode of OBJECT2 = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of OBJECT2 failed\n");

	if(cfstat("OBJECT3", &stats) == OK)
		cfprintf("mode of OBJECT3 = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of OBJECT3 failed\n");

	if(cfstat("OBJECT4", &stats) == OK)
		cfprintf("mode of OBJECT4 = %lx obtype=%lx\n", stats.st_mode, stats.st_obtype);
	else
		cfprintf("stat of OBJECT4 failed\n");


	cfprintf("GET OBTYPE OF FILES THAT ARE CLOSED by name\n");
	cfprintf("obtype of PLAINFILE = %lx\n", cfobtype("PLAINFILE"));
	cfprintf("obtype of TESTFILE = %lx\n", cfobtype("TESTFILE"));
	cfprintf("obtype of OBJECT1 = %lx\n", cfobtype("OBJECT1"));
	cfprintf("obtype of OBJECT2 = %lx\n", cfobtype("OBJECT2"));
	cfprintf("obtype of OBJECT3 = %lx\n", cfobtype("OBJECT3"));
	cfprintf("obtype of OBJECT4 = %lx\n", cfobtype("OBJECT4"));

	cfprintf("REOPEN THE FILES\n");
	h3 = cfopen("OBJECT2", F_RDWR, NULL);
	h1 = cfopen("TESTFILE", F_RDWR, NULL);
	h2 = cfopen("OBJECT1", F_RDWR, NULL);
	h6 = cfopen("PLAINFILE", F_RDWR, NULL);
	h4 = cfopen("OBJECT3", F_RDWR, NULL);
	h5 = cfopen("OBJECT4", F_RDWR, NULL);
}

static void
dir_test()
{
	cfprintf("\nDIRECTORY SCAN TESTS\n");
	cfprintf("DIRECTORY of .\n");
	print_dir(".");
	cfprintf("DIRECTORY of TESTFILE open by handle\n");
	print_dir(h1);
	cfprintf("DIRECTORY of TESTFILE open by name\n");
	print_dir("TESTFILE");
	cfprintf("DIRECTORY of OBJECT1 open by handle\n");
	print_dir(h2);
	cfprintf("DIRECTORY of OBJECT1 open by name\n");
	print_dir("OBJECT1");
	cfprintf("DIRECTORY of OBJECT2 open by handle\n");
	print_dir(h3);
	cfprintf("DIRECTORY of OBJECT2 open by name\n");
	print_dir("OBJECT2");

	cfprintf("\nCLOSE THE FILES\n");
	cfclose(h1);
	cfclose(h2);
	cfclose(h3);
	cfclose(h4);
	cfclose(h5);
	cfclose(h6);

	cfprintf("DIRECTORY of TESTFILE closed by name\n");
	print_dir("TESTFILE");
	cfprintf("DIRECTORY of OBJECT1 closed by name\n");
	print_dir("OBJECT1");
	cfprintf("DIRECTORY of OBJECT2 closed by name\n");
	print_dir("OBJECT2");
}
static void
print_dir(void *path)
{
void *h;
CFDIRENT *dir;
int i = 0;

	h = cfopendir(path,NULL);
	while((dir = cfreaddir(h))) {
		cfprintf("%d:\t%s\n", ++i, dir->d_name);
	}
	cfclosedir(h);
}

