/* PERMTEST.C */
/* Copyright 1990, 1991, 1992, 1993 Norman D. Culver Ft. Lauderdale, FL */
/*					All Rights Reserved 			  				    */

#include <stdlib.h>
#include "../cff.h"

static void perm_test();
#define PACKSIZE 100

void
main()
{
	cfport_settestflags(1);
	cfinit("permtest",1024,"myfile.cff");
	cfprintf("TEST OF PERMANENT OBJECTS -- mallocC(-n)\n");

	perm_test();

	cfexit();

} /* MAIN */

static void
perm_test()
{
char **ptrs1[PACKSIZE];
char **ptrs2[PACKSIZE];
char **ptrs3[PACKSIZE];
char **pp1;
char **pp2;
char **pp3;
int i,j,errors=0;

	cfprintf("Begin perm_test\n");

	if(!cfisnew(PERMINFO))
	{
		/* The file containing permanent objects is not new.
			Read in some pointers which were saved. The data
			has already been loaded by cfinit(). */

		cfprintf("READ, CHECK and DELETE old data\n");
		for(i = 0; i < PACKSIZE; ++i)
			ptrs1[i] = ptrs2[i] = NULL;

		if(cfget(PERMINFO, "ptrs1", 5, ptrs1, sizeof(ptrs1)) < FOUND) {
			cfprintf("Failed to get ptrs1\n");
			return;
		}
		if(cfget(PERMINFO, "ptrs2", 5, ptrs2, sizeof(ptrs2)) < FOUND) {
			cfprintf("Failed to get ptrs2\n");
			return;
		}

		for(i = 0; i < PACKSIZE; ++i)
		{
			if(!(pp1 = ptrs1[i])) {
				cfprintf("pp1 is NULL at i=%d\n", i);
				++errors;
				continue;
			}
			if(!(pp2 = ptrs2[i])) {
				cfprintf("pp2 is NULL at i=%d\n", i);
				++errors;
				continue;
			}
			for(j = 0; j < 100; ++j)
			{
				if(pp1)
					if(!pp1[j] || (*(pp1[j]) != j)) {
						cfprintf("pp1 fails at i=%d j=%d pp1=%p pp1[j]=%p dat=%lx\n", i, j, pp1, pp1[j], *((long *)(pp1[j])));
						++errors;
						break;
					}
				if(pp2)
					if(!pp2[j] || (*(pp2[j]) != j)) {
						cfprintf("pp2 fails at i=%d j=%d pp2=%p pp2[j]=%p dat=%lx\n", i, j, pp2, pp2[j], *((long *)(pp2[j])));
						++errors;
						break;
					}
			}
		}

		freecat(-1);
		freecat(-2);
		cfprintf("READ, CHECK and DELETE FINISHED\n");
	}
	if(errors) {
		cfprintf("Errors detected.\n");
		exit(-1);
	}
	cfprintf("ENTER NEW DATA\n");
	/* Enter new data */
	for(i = 0; i < PACKSIZE; ++i)
	{
		if(!(ptrs1[i] = mallocC(-1, 100*sizeof(char *)))) {
			cfprintf("Failed to mallocC for category #1 i=%d\n", i);
			return;
		}
		if(!(ptrs2[i] = mallocC(-2, 100*sizeof(char *)))) {
			cfprintf("Failed to mallocC for category #2 i=%d\n", i);
			return;
		}
		if(!(ptrs3[i] = mallocC(-3, 100*sizeof(char *)))) {
			cfprintf("Failed to mallocC for category #3 i=%d\n", i);
			return;
		}
		pp1 = ptrs1[i];
		pp2 = ptrs2[i];
		pp3 = ptrs3[i];

		for(j = 0; j < 100; ++j)
		{
		char *p;
			/* Bigtime waste of space */
			if(!(p = pp1[j] = mallocC(-1, 1)))
				cfprintf("mallocC(-1,1) failed at i=%d j=%d\n", i,j);
			*p = j;
			if(!(p = pp2[j] = mallocC(-2, 1)))
				cfprintf("mallocC(-2,1) failed at i=%d j=%d\n", i,j);
			*p = j;
			if(!(p = pp3[j] = mallocC(-3, 1)))
				cfprintf("mallocC(-3,1) failed at i=%d j=%d\n", i,j);
			*p = j;
		}
	}
	freecat(-3); /* Throw away category 3 */

	/* Save the packs of pointers -- the data will be saved by cfexit() */

	if(cfreput(PERMINFO, "ptrs1", 5, ptrs1, sizeof(ptrs1), NULL) == NULL)
		cfprintf("Failed to store ptrs1\n");
	if(cfreput(PERMINFO, "ptrs2", 5, ptrs2, sizeof(ptrs2), NULL) == NULL)
		cfprintf("Failed to store ptrs2\n");

	cfprintf("ENTER NEW DATA FINISHED\n");

	cfprintf("End perm_test\n");
}
