/* PUSHTEST.C */
/* Copyright 1990, 1991, 1992, 1993 Norman D. Culver Ft. Lauderdale, FL */
/*					All Rights Reserved 			  				    */

#include <stdlib.h>
#include "../cff.h"

#define CLOCKS_PER_SECOND 1000000L

/* TEST CHOICES */
#define PFLAGS 0
#define MEMFILE 1
#define EXTDMEM 1
#define DOHASH 1
#define DOTREE 1

extern int errno;
extern long clock();
extern int rand();
static void push_test1(void *hd, void *hd1);
static void push_test2(void *hd, void *hd1);

OPNINFO info;

void
main()
{
void *hxxx;
void *huniq;
void *huniq1;
void *huniq2;
void *huniq3;
void *hsxxx;
void *hsxxx1;
void *hsxxx2;
void *hsxxx3;

	cfport_settestflags(1);
	cfinit("pushtest",512,NULL);
	cfprintf("PUSH/POP test of stack property -- stack depth == 10000\n");

	/* SET UP PREALLOC FOR THE HASH DIRECTORIES */

#if MEMFILE
	/* EXTRANEOUS DIRECTORY just to add flavor */
	cfprintf("MEMORY FILE\n");
	hxxx = cfopen("MEMORY/XXX",F_RDWR|F_CREAT,NULL);
	if(!hxxx) {
		cfprintf("ERROR: create XXX err=%d\n", errno);
		exit(0);
	}

	/* HASH DIRECTORY WITH PREALLOC OF MAPS ONLY */
	info.initial_entries = 10000;
	info.bitmap_prealloc = 0;
	info.data_prealloc = 0;
	huniq = cfopen("MEMORY/XXX",
					F_RDWR|F_CREAT|F_TEMP|F_UNIQ|F_HUGEDIR, &info);
	if(!huniq) {
		cfprintf("ERROR: create UNIQUE TEMP FILE0 err=%d\n", errno);
		exit(0);
	}

	/* TREE DIRECTORY no prealloc */
	huniq1 = cfopen("MEMORY/XXX",
					F_RDWR|F_CREAT|F_TEMP|F_UNIQ|F_SORTED, NULL);
	if(!huniq1) {
		cfprintf("ERROR: create UNIQUE TEMP FILE1 err=%d\n", errno);
		exit(0);
	}
	/* HASH DIRECTORY WITH PREALLOC OF MAPS AND DATA */
	info.initial_entries = 10000;
	info.bitmap_prealloc = 0;
	info.data_prealloc = 64;
	huniq2 = cfopen("MEMORY/XXX",
					F_RDWR|F_CREAT|F_TEMP|F_UNIQ|F_HUGEDIR, &info);
	if(!huniq2) {
		cfprintf("ERROR: create UNIQUE TEMP FILE2 err=%d\n", errno);
		exit(0);
	}
	/* TREE DIRECTORY no prealloc */
	huniq3 = cfopen("MEMORY/XXX",
					F_RDWR|F_CREAT|F_TEMP|F_UNIQ|F_SORTED, NULL);
	if(!huniq3) {
		cfprintf("ERROR: create UNIQUE TEMP FILE3 err=%d\n", errno);
		exit(0);
	}
#if PFLAGS
	cfpflags("hxxx", hxxx);
	cfpflags("huniq", huniq);
	cfpflags("huniq1", huniq1);
	cfpflags("huniq2", huniq2);
	cfpflags("huniq3", huniq3);
#endif

	cfsetverylazy(huniq);
	cfsetverylazy(huniq1);
	push_test1(huniq, huniq1);

	cfsetverylazy(huniq2);
	cfsetverylazy(huniq3);
	push_test2(huniq2, huniq3);

cfprintf("NOW CLOSING\n");
	cfclose(huniq);
	cfclose(huniq1);
	cfclose(huniq2);
	cfclose(huniq3);
#endif /* MEMFILE */


#if EXTDMEM
	cfprintf("EXTDMEM FILE\n");

	/* HASH DIRECTORY WITH PREALLOC OF MAPS ONLY */
	info.initial_entries = 10000;
	info.bitmap_prealloc = 0;
	info.data_prealloc = 0;
	hsxxx = cfopen("EXTDMEM/XXX", F_RDWR|F_CREAT|F_HUGEDIR, &info);
	if(!hsxxx) {
		cfprintf("ERROR: create EXTDMEM/XXX err=%d\n", errno);
		exit(0);
	}

	/* TREE DIRECTORY no prealloc */
	hsxxx1 = cfopen("EXTDMEM/XXX1", F_RDWR|F_CREAT|F_SORTED, NULL);
	if(!hsxxx1) {
		cfprintf("ERROR: create EXTDMEM/XXX1 err=%d\n", errno);
		exit(0);
	}

	/* HASH DIRECTORY WITH PREALLOC OF MAPS and DATA */
	info.initial_entries = 10000;
	info.bitmap_prealloc = 0;
	info.data_prealloc = 64;
	hsxxx2 = cfopen("EXTDMEM/XXX2", F_RDWR|F_CREAT|F_HUGEDIR, &info);
	if(!hsxxx2) {
		cfprintf("ERROR: create EXTDMEM/XXX2 err=%d\n", errno);
		exit(0);
	}

	/* TREE DIRECTORY no prealloc */
	hsxxx3 = cfopen("EXTDMEM/XXX3", F_RDWR|F_CREAT|F_SORTED, NULL);
	if(!hsxxx3) {
		cfprintf("ERROR: create EXTDMEM/XXX3 err=%d\n", errno);
		exit(0);
	}

#if PFLAGS
	cfpflags("hsxxx", hsxxx);
	cfpflags("hsxxx1", hsxxx1);
	cfpflags("hsxxx2", hsxxx2);
	cfpflags("hsxxx3", hsxxx3);
#endif

	cfsetverylazy(hsxxx);
	cfsetverylazy(hsxxx1);
	push_test1(hsxxx, hsxxx1);

	cfsetverylazy(hsxxx2);
	cfsetverylazy(hsxxx3);
	push_test2(hsxxx2, hsxxx3);

cfprintf("NOW CLOSING\n");
	cfclose(hsxxx);
	cfclose(hsxxx1);
	cfclose(hsxxx2);
	cfclose(hsxxx3);

	cfprintf("REOPEN EXTDMEM FILE\n");	
	hsxxx = cfopen("EXTDMEM/XXX", F_RDWR, NULL);
	if(!hsxxx) {
		cfprintf("ERROR: reopen EXTDMEM:/XXX err=%d\n", errno);
		exit(0);
	}
	hsxxx1 = cfopen("EXTDMEM/XXX1", F_RDWR, NULL);
	if(!hsxxx1) {
		cfprintf("ERROR: reopen EXTDMEM:/XXX1 err=%d\n", errno);
		exit(0);
	}
	hsxxx2 = cfopen("EXTDMEM/XXX2", F_RDWR, NULL);
	if(!hsxxx2) {
		cfprintf("ERROR: reopen EXTDMEM:/XXX2 err=%d\n", errno);
		exit(0);
	}
	hsxxx3 = cfopen("EXTDMEM/XXX3", F_RDWR, NULL);
	if(!hsxxx3) {
		cfprintf("ERROR: reopen EXTDMEM:/XXX3 err=%d\n", errno);
		exit(0);
	}

	cfsetverylazy(hsxxx);
	cfsetverylazy(hsxxx1);
	push_test1(hsxxx,hsxxx1);

	cfsetverylazy(hsxxx2);
	cfsetverylazy(hsxxx3);
	push_test2(hsxxx2,hsxxx3);

cfprintf("NOW UNLINKING\n");
	cfunlink(hsxxx, NULL);
	cfunlink(hsxxx1, NULL);
	cfunlink(hsxxx2, NULL);
	cfunlink(hsxxx3, NULL);
#endif /* EXTDMEM */
cfprintf("UNLINK DONE\n");
	cfexit();
} /* END: MAIN */
static Item myitem;
static long buf[16];

static void
push_test1(void *hd, void *hd1)
{
long i, start, end, diff, result;

	cfprintf("Begin push_test1 ITEMS\n");

#if DOHASH == 1
	if((result = cfstackdepth(hd)) != 0)
		cfprintf("STACKDEPTH begin hash wrong =%d should be 0\n", result);

	start = clock();
	for (i = 0; i < 10000; ++i)
	{
		myitem.a0 = i+2;
		if((result = cfpush_item(hd, &myitem)) != i+1)
			cfprintf("PUSH ITEM hash failed =%d should be %d\n", result, i+1);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  PUSH ITEMS hash PER SEC = %ld\n", (i*10) / diff);

	if((result = cfstackdepth(hd)) != 10000)
	cfprintf("STACKDEPTH push hash item wrong =%d should be 10000\n", result);

	start = clock();
	for (i = 9999; i >= 0; --i)
	{
		myitem.a0 = 0;
		if((result = cfpop_item(hd, &myitem)) != i)
			cfprintf("POP ITEM hash failed =%d should be %d\n", result, i+1);
		if(myitem.a0 != i+2)
			cfprintf("POP ITEM returned wrong value %d should be %d\n",
			myitem.a0, i+2);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  POP ITEMS hash PER SEC = %ld\n", (10000*10) / diff);

	if((result = cfstackdepth(hd)) != 0)
	cfprintf("STACKDEPTH pop hash item wrong =%d should be 0\n", result);

#endif
#if DOTREE == 1
	if((result = cfstackdepth(hd1)) != 0)
		cfprintf("STACKDEPTH begin tree wrong =%d should be 0\n", result);

	start = clock();
	for (i = 0; i < 10000; ++i)
	{
		myitem.a0 = i+2;
		if((result = cfpush_item(hd1, &myitem)) != i+1)
			cfprintf("PUSH ITEM tree failed =%d should be %d\n", result, i+1);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  PUSH ITEMS tree PER SEC = %ld\n", (i*10) / diff);

	if((result = cfstackdepth(hd1)) != 10000)
	cfprintf("STACKDEPTH push tree item wrong =%d should be 10000\n", result);


	start = clock();
	for (i = 9999; i >= 0; --i)
	{
		myitem.a0 = 0;
		if((result = cfpop_item(hd1, &myitem)) != i)
			cfprintf("POP ITEM tree failed =%d should be %d\n", result, i+1);
		if(myitem.a0 != i+2)
			cfprintf("POP ITEM tree returned wrong value %d should be %d\n",
			myitem.a0, i+2);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  POP ITEMS tree PER SEC = %ld\n", (10000*10) / diff);

	if((result = cfstackdepth(hd1)) != 0)
	cfprintf("STACKDEPTH pop tree item wrong =%d should be 0\n", result);

#endif

	cfprintf("End push_test1\n");
}
static void
push_test2(void *hd, void *hd1)
{
long i, start, end, diff, result;

	cfprintf("Begin push_test2 DATA (64 bytes) \n");

#if DOHASH == 1
	if((result = cfstackdepth(hd)) != 0)
		cfprintf("STACKDEPTH begin hash wrong =%d should be 0\n", result);

	start = clock();
	for (i = 0; i < 10000; ++i)
	{
		buf[0] = i+2;
		buf[15] = i+3;
		if((result = cfpush_data(hd, buf, 64)) != i+1)
			cfprintf("PUSH DATA  hash failed =%d should be %d\n", result, i+1);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  PUSH DATA hash PER SEC = %ld\n", (i*10) / diff);

	if((result = cfstackdepth(hd)) != 10000)
	cfprintf("STACKDEPTH push hash data wrong =%d should be 10000\n", result);

	start = clock();
	for (i = 9999; i >= 0; --i)
	{
		if((result = cfpop_data(hd, buf, 64)) != i)
			cfprintf("POP DATA hash failed =%d should be %d\n", result, i+1);
		if(buf[0] != i+2 || buf[15] != i+3)
			cfprintf("POP DATA returned wrong value %d should be %d\n",
			buf[0], i+2);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  POP DATA hash PER SEC = %ld\n", (10000*10) / diff);

	if((result = cfstackdepth(hd)) != 0)
	cfprintf("STACKDEPTH pop hash item wrong =%d should be 0\n", result);


#endif
#if DOTREE == 1
	if((result = cfstackdepth(hd1)) != 0)
		cfprintf("STACKDEPTH begin tree wrong =%d should be 0\n", result);

	start = clock();
	for (i = 0; i < 10000; ++i)
	{
		buf[0] = i+2;
		buf[15] = i+3;
		if((result = cfpush_data(hd1, buf, 64)) != i+1)
			cfprintf("PUSH DATA tree failed =%d should be %d\n", result, i+1);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  PUSH DATA tree PER SEC = %ld\n", (i*10) / diff);

	if((result = cfstackdepth(hd1)) != 10000)
	cfprintf("STACKDEPTH push tree data wrong =%d should be 10000\n", result);


	start = clock();
	for (i = 9999; i >= 0; --i)
	{
		if((result = cfpop_data(hd1, buf, 64)) != i)
			cfprintf("POP DATA tree failed =%d should be %d\n", result, i+1);
		if(buf[0] != i+2 || buf[15] != i+3)
			cfprintf("POP DATA tree returned wrong value %d should be %d\n",
			buf[0], i+2);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  POP DATA tree PER SEC = %ld\n", (10000*10) / diff);

	if((result = cfstackdepth(hd1)) != 0)
	cfprintf("STACKDEPTH pop tree data wrong =%d should be 0\n", result);


#endif

	cfprintf("End push_test2\n");
}

