/* dofile.c -- Miscellaneous file-handling functions



Miscellaneous file-handling functions.


*/

/* MSDOS revisions - Michael Murphy 1993
 * __MSDOS__ for include files
 * include <sys\stat.h>, <io.h> for creat
 * change from UNIX permission bits
 * pragma for pointer arithmetic
 */

#include "dofile.h"
#include <string.h>
#include <fcntl.h>
// MFM
//#ifdef __DECCXX
#if defined(__MSDOS__)
#include <sys\stat.h>
#include <io.h>
#endif
#if defined(__DECCXX) || defined(__MSDOS__)
#include <stdlib.h>
#else
#include <osfcn.h>
#endif
#include <iostream.h>
#include <fstream.h>

extern int errno;

#pragma warn -sig
/* base_filename -- extract base file name (drop extension) */
char* base_filename(char* p) {
  char* p0 = p;

  while ( (*p0 != '\0')&&(*p0 != '.') ) ++p0;
  // MFM - pointer arithmentic
  char* q = new char[p0-p+1];
  char* q0 = q;
  while ( p != p0 )
    *(q++) = *(p++);
  *q = '\0';
  return q0;
}/* base_filename */
#pragma warn .sig

/* ext_filename -- extract extension from filename */
char* ext_filename(char* p) {
  while ( (*p != '\0')&&(*p != '.') ) ++p;
  char* q = new char[strlen(p)+1];
  strcpy(q,p);
  return q;
} /* end ext_filename*/


ostream* open_ostream(char* fname) {
  errno = 0;

  int fd;
  // MFM
  //ostream* strm = new ofstream((fd=creat(fname,0664),fd));
  ostream* strm = new ofstream((fd=creat(fname,S_IWRITE),fd));

  if ( fd == -1 ) {
   switch ( errno ) {
     case 2:
       cerr << "errgen> file does not exist -- " << fname << "\n";
       break;
     default:
       cerr << "errgen> file not open -- " << fname << "\n";
       break;
     }
   exit(1);
   }
  cerr << "open_ostream> " << fname << "\n";
  return strm;
}

ostream* append_ostream(char* fname) {
cerr << "append_ostream> " << fname << "\n";
  int fd;
  ostream* strm = new ofstream((fd=open(fname,O_APPEND),fd));
  if ( fd == -1 ) {
   cerr << "errgen> file not open -- " << fname << "\n";
   exit(1);
   }
  return strm;
}

istream* open_istream(char* fname) {
  errno = 0;
  int fd;
  istream* strm = new ifstream((fd=open(fname,O_RDONLY),fd));
  if ( fd == -1 ) {
    switch ( errno ) {
      case 2:
        cerr << "errgen> file does not exist -- " << fname << "\n";
        break;
      default:
        cerr << "errgen> file not open -- " << fname << "\n";
        break;
      }

   exit(1);
   }
  cerr << "open_istream> " << fname << "\n";
  return strm;
}
