#ifndef ArrayPartialH
#define ArrayPartialH

// ArrayPartial.h -- Array of Partial derivatives

#include "Partial.h"

class ostream;
class Matrix;
class MatrixRow;

class ArrayPartial {
    Partial* p;
    int sz;
public:
    ArrayPartial(int siz, double*);
    ArrayPartial(int siz, Partial* =0);
    ArrayPartial(const ArrayPartial&);
    ~ArrayPartial();

    void operator=(const ArrayPartial&);
    int size() const { return sz; }
    Partial at(int Kth) const { return p[Kth]; }
    Partial& at(int Kth) { return p[Kth]; }
    Partial operator[](int Kth) const;
    Partial& operator[](int Kth);
    void operator+=(const Matrix&);

    Matrix value() const;
    Matrix jacobian() const;
    ArrayPartial operator+(const ArrayPartial&);
    friend ArrayPartial operator*(double,const ArrayPartial&);
    friend ArrayPartial operator*(const Matrix&,
                                  const ArrayPartial&);
    
    virtual void printOn(ostream& strm) const;
};
#endif /*ArrayPartialH*/
