// ex13-9.c -- MI with the NIH Class Library

// $Header: /afs/alw.nih.gov/system/src/local/nihcl/311/share/ex/RCS/ex13-9.c,v 3.12 92/08/13 12:47:31 sandy Exp $

#include "LandVhcl.h"
#include "WaterVhc.h"
#include "AmphibVh.h"
#include "StopLigh.h"
#include "DrawBrid.h"

StopLightQ stopLightQ[2];
DrawBridgeQ drawBridgeQ;

void main()
{
	 stopLightQ[0].addVehicle(*new LandVhcl(4.1, 12.0));
	 stopLightQ[1].addVehicle(*new LandVhcl(4.2, 12.0));
	 stopLightQ[0].addVehicle(*new LandVhcl(4.3, 12.0));
	 stopLightQ[1].addVehicle(*new LandVhcl(4.4, 12.0));
	 drawBridgeQ.addVehicle(*new WaterVhcl(21.0, 19.0, 3.5));
	 drawBridgeQ.addVehicle(*new WaterVhcl(10.0, 30.0, 2.0));
	 stopLightQ[0].addVehicle(*new AmphibVhcl(5.0, 15.0, 3.0));
	 drawBridgeQ.addVehicle(*new AmphibVhcl(5.1, 15.0, 3.0));

	 cout << "allVehicles:\n"; Vehicle::printAll();
	 cout << endl;
	 cout << "stopLightQ[0]:\n"; stopLightQ[0].printOn();
	 cout << endl;
	 cout << "stopLightQ[1]:\n"; stopLightQ[1].printOn();
	 cout << endl;
	 cout << "drawBridgeQ:\n"; drawBridgeQ.printOn();
	 cout << endl;

	 cout << "Test deepCopy()" << endl;
	 Vehicle* copy =
		  Vehicle::castdown(drawBridgeQ.last()->deepCopy());
	 cout << *copy << endl;
	 cout << "allVehicles:\n"; Vehicle::printAll(); cout << endl;
	 delete copy;
	 cout << "allVehicles:\n"; Vehicle::printAll(); cout << endl;

	 Vehicle::saveQueues("trafficf.ile",
		  &stopLightQ[0], &stopLightQ[1], &drawBridgeQ, 
#ifndef _MSC_VER
		  NULL
#else
		  0UL
#endif
		  );
}
