// ex5-10 -- one dimensional automatic derivatives with
//           class AutoDeriv

// $Header: /afs/alw.nih.gov/system/src/local/nihcl/311/share/ex/RCS/ex5-10.c,v 3.12 92/08/13 12:47:34 sandy Exp $


#include <iostream.h>
#include "AutoDeri.h"

#ifdef _MSC_VER
#define M_PI_2      1.57079632679489661923   
#else
#include <math.h>
#endif

const double halfPI = M_PI_2; 

void main()
{
    AutoDeriv W(0,1);
    AutoDeriv Y_plus = W+1;
    AutoDeriv Y_times= W*2;
    AutoDeriv Z = 2*W*(W+2) + W + 1;
    cout << "W=" << W << endl;
    cout << "W+1=" << Y_plus << endl;
    cout << "W*2=" << Y_times << endl;
    cout << "Z = 2*W*(W+2)+W+1="<< Z << endl;
    cout << "(2*(W+1)).pow(3)=" << (2*(W+1)).pow(3) << endl;
    cout << "2*W*Z.pow(2)=" << 2*W*Z.pow(2) << endl;
    cout << endl;

    // evaluate 2*x*(sin(x)+1) at x=0
    AutoDeriv X(0,1);
    AutoDeriv Y = 2*X*(Sin(X)+1);

    cout << "let  X = [F(X),dF(X)] = "
         << "[" << F(X)  << "," << dF(X) << "]" 
         << endl;
    cout << "let  Y = 2*X*(Sin(X)+1)" << "\n"
         << "then Y = [F(Y),dF(Y)] = "
         << "[" << F(Y)  << "," << dF(Y) << "]" 
         << endl<< endl;
    
    // evaluate 2*x*(sin(x)+1) at x=halfPI
    AutoDeriv U(halfPI,1); 
    AutoDeriv V = 2*U*(Sin(U)+1);

    cout << "let  U = [F(U),dF(U)] = "
         << "[" << F(U)  << "," << dF(U) << "]" 
         << endl;
    cout << "let  V = 2*U*(Sin(U)+1)" << "\n"
         << "then V = [F(V),dF(V)] = "
         << "[" << F(V)  << "," << dF(V) << "]" 
         << endl;
}
