// ex6-4.c -- Calling a virtual function from a
//            base class constructor

// $Header: /afs/alw.nih.gov/system/src/local/nihcl/311/share/ex/RCS/ex6-4.c,v 3.10 91/02/23 22:00:54 kgorlen Rel Locker: sandy $

#include <iostream.h>

class A {
public:
    virtual void vf();
};

void A::vf()    { cout << "A::vf()" << endl; }

class B: public A {
public:
    B()         { vf(); }   // Calls A::vf(), not C::vf()
};

class C: public B {
public:
    C()         { vf(); }   // Calls C::vf()
    virtual void vf();
};

void C::vf()    { cout << "B::vf()" << endl; }

void main()
{
    C c;
}
