#ifndef	ARRAYOB_H
#define	ARRAYOB_H

/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: ArrayOb.h,v 3.12 92/07/26 14:31:48 */ 

#include "nihclstd.h"
#pragma hdrstop

#include "Collecti.h"

class ArrayOb: public Collection {
	DECLARE_MEMBERS(ArrayOb);
	Object** v;
	unsigned sz;
	void allocSizeErr() const;
	void indexRangeErr() const;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	ArrayOb(unsigned size =DEFAULT_CAPACITY);
	ArrayOb(const ArrayOb&);
	~ArrayOb();
	Object*& elem(int i)			{ return v[i]; }
#if defined(REFTOTEMP)
	// BCC reference to temporary error - add cast
	// MSC silent
	const Object *const& elem(int i) const
		{ return (const Object *const&)(v[i]); }
#else
	const Object *const& elem(int i) const	{ return v[i]; }
#endif
	bool operator!=(const ArrayOb& a) const	{ return !(*this==a); }
	void operator=(const ArrayOb&);
	bool operator==(const ArrayOb&) const;  
	Object*& operator[](int	i) {
		if ((unsigned)i >= sz) indexRangeErr();
		return v[i];
	}            
#if defined(REFTOTEMP)
	// BCC error reference to temporary - add cast
	// MSC silent
	const Object *const& operator[](int i) const
		{
		if ((unsigned)i >= sz) indexRangeErr();
		return (const Object *const&)(v[i]);
		}   
#else
	const Object *const& operator[](int i) const	{
		if ((unsigned)i >= sz) indexRangeErr();
		return v[i];
	}
#endif
	virtual Collection& addContentsTo(Collection&) const;
	virtual Object*& at(int i);
	virtual const Object *const& at(int i) const;
	virtual unsigned capacity() const;
	virtual int compare(const Object&) const;
	virtual void deepenShallowCopy();
	virtual Object* doNext(Iterator&) const;
	virtual unsigned long hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void reSize(unsigned);
	virtual void removeAll();
	virtual unsigned size() const;
	virtual void sort();
	virtual const Class* species() const;
private:			    // shouldNotImplement();
	virtual	Object* add(Object&);
	virtual unsigned occurrencesOf(const Object&) const;
	virtual Object* remove(const Object&);
};

#endif
