#ifndef	BAG_H
#define	BAG_H

/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */
/* Bag.h,v 3.13 92/07/26 14:31:54 */

#include "nihclstd.h"
#pragma hdrstop

#include "Collecti.h"
#include "Dictiona.h"

class Bag: public Collection {
	DECLARE_MEMBERS(Bag);
	unsigned count;
	Dictionary contents;
protected:
	void _reader(OIOifd&);	// read Bag from stream
	void _reader(OIOin&);	// read Bag from file
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Bag(unsigned size =DEFAULT_CAPACITY);
	Bag(const Bag&);
	~Bag();
	Object* addWithOccurrences(Object&, unsigned);
	bool operator!=(const Bag& a) const		{ return !(*this==a); }
	void operator=(const Bag&);
	bool operator==(const Bag&) const;
	virtual	Object*	add(Object&);
	virtual Object*& at(int);
	virtual const Object *const& at(int) const;
	virtual unsigned capacity() const;
	virtual void deepenShallowCopy();
	virtual Object*	doNext(Iterator&) const;
	virtual	void dumpOn(ostream& strm =cerr) const;
	virtual unsigned long hash() const;
	virtual bool isEqual(const Object&) const;
	virtual unsigned occurrencesOf(const Object&) const;
	virtual void reSize(unsigned);
	virtual Object*	remove(const Object&);
	virtual void removeAll();
	virtual unsigned size() const;
	virtual const Class* species() const;
private:			    // shouldNotImplement()
	virtual int compare(const Object&) const;
};

#endif
