#ifndef	BITBOARD_H
#define	BITBOARD_H
                  
/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */
/* BitBoard.h,v 3.12 93/02/07 15:11:40 */

#include "nihclstd.h"
#pragma hdrstop

class BitBoard: public VIRTUAL Object {
	DECLARE_MEMBERS(BitBoard);
	union {
		unsigned long m[2];
		unsigned char c[8];
	};
public:
	static void init(const Class&);
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	BitBoard() {}
	BitBoard(unsigned i);
	BitBoard(unsigned long i, unsigned long j) { m[0] = i;  m[1] = j; }
	BitBoard operator~() const		{ return BitBoard(~m[0], ~m[1]); }
	BitBoard operator-(const BitBoard& n) const	{ return BitBoard(m[0]&~n.m[0], m[1]&~n.m[1]); }
	bool operator>(const BitBoard& n) const { return m[0] == (m[0]|n.m[0])
						&& m[0] != n.m[0]
						&& m[1] == (m[1]|n.m[1])
						&& m[1] != n.m[1]; }
	bool operator<(const BitBoard& n) const { return n > *this; }
	bool operator>=(const BitBoard& n) const { return m[0] == (m[0]|n.m[0])
						&& m[1] == (m[1]|n.m[1]); }
	bool operator<=(const BitBoard& n) const { return n >= *this; }
	bool operator==(const BitBoard& n) const { return m[0] == n.m[0] && m[1] == n.m[1]; }
	bool operator!=(const BitBoard& n) const { return m[0] != n.m[0] || m[1] != n.m[1]; }
	BitBoard operator|(const BitBoard& n) const { return BitBoard(m[0]|n.m[0], m[1]|n.m[1]); }
	BitBoard operator&(const BitBoard& n) const { return BitBoard(m[0]&n.m[0], m[1]&n.m[1]); }
	BitBoard operator^(const BitBoard& n) const { return BitBoard(m[0]^n.m[0], m[1]^n.m[1]); }
 	void operator-=(const BitBoard& n)	{ m[0] &= ~n.m[0]; m[1] &= ~n.m[1]; }
	void operator&=(const BitBoard& n)	{ m[0] &= n.m[0]; m[1] &= n.m[1]; }
	void operator^=(const BitBoard& n)	{ m[0] ^= n.m[0]; m[1] ^= n.m[1]; }
	void operator|=(const BitBoard& n)	{ m[0] |= n.m[0]; m[1] |= n.m[1]; }
	unsigned count() const;
	bool includes(unsigned i) const;
	virtual unsigned capacity() const;
	virtual void deepenShallowCopy();	// {}
	virtual unsigned long hash() const;
	virtual bool isEmpty() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual unsigned size() const;
	virtual const Class* species() const;
private:			    // shouldNotImplement()
	virtual int compare(const Object&) const;
};

extern BitBoard squareBitBoard[64];
extern BitBoard rankBitBoard[8];
extern BitBoard fileBitBoard[8];
extern unsigned char bit_count[256];

inline BitBoard::BitBoard(unsigned i)	{ *this = squareBitBoard[i]; }
	
inline unsigned BitBoard::count() const
{
	unsigned const char* p = (unsigned const char*)c;
	unsigned n = 0;
	n += bitCount(*p++);
	n += bitCount(*p++);
	n += bitCount(*p++);
	n += bitCount(*p++);
	n += bitCount(*p++);
	n += bitCount(*p++);
	n += bitCount(*p++);
	n += bitCount(*p++);
	return n;
}

inline bool BitBoard::includes(unsigned i) const
{
	return (m[0] & squareBitBoard[i].m[0]) || (m[1] & squareBitBoard[i].m[1]);
}

#endif
