#ifndef	DATE_H
#define	DATE_H
                 
/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */                 
/* Date.h,v 3.11 92/07/26 14:32:05 */
/* 
 * long operator-
 *
 * compare() needs to be long to handle full date range
 *		but this conflicts with int declaration for Object
 *  	use same fix as Integer
 */

#include "nihclstd.h"
#pragma hdrstop

class Date: public VIRTUAL Object {
	DECLARE_MEMBERS(Date);
public:			// type definitions 
	// int instead of short - MFM
	typedef unsigned /*short*/ dayTy;
	typedef unsigned /*short*/ monthTy;
	typedef unsigned /*short*/ yearTy;
	typedef unsigned long  julTy;
public:			// static member functions
	static dayTy dayOfWeek(const char* dayName);
	static bool dayWithinMonth(monthTy month, dayTy day, yearTy year);
	static dayTy daysInYear(yearTy year);
	static julTy jday(monthTy m, dayTy d, yearTy y);
	static bool leapYear(yearTy year);
	static const char* nameOfDay(dayTy weekDayNumber);
	static const char* nameOfMonth(monthTy monthNumber);
	static monthTy numberOfMonth(const char* monthName);
private:		// private member variables
        julTy julnum;   // Julian Day Number (Not same as Julian date.  Jan. 29, 1988 
                        // is not the same as 88029 in Julian Day Number.)
	Date(julTy j)                   { julnum = j; }
	julTy parseDate(istream&);
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Date();				// current date 
	Date(long dayCount);
	Date(long dayCount, yearTy referenceYear);
	Date(dayTy newDay, const char* monthName, yearTy newYear);
	Date(istream&);			// read date from stream
#if defined(MIBADDEFAULTFCNS)
	Date::Date(const Date& copyfrom);
	Date& Date::operator=(const Date& rhs);
#endif
	bool operator<(const Date& date) const	{ return julnum < date.julnum; }
	bool operator<=(const Date& date) const	{ return julnum <= date.julnum; }
	bool operator>(const Date& date) const	{ return date < *this; }
	bool operator>=(const Date& date) const	{ return date <= *this; }
	bool operator==(const Date& date) const	{ return julnum == date.julnum; }
	bool operator!=(const Date& date) const	{ return julnum != date.julnum; }
	friend Date operator+(const Date& dt, int dd)	{ return Date(dt.julnum + dd); }
	friend Date operator+(int dd, const Date& dt)	{ return Date(dt.julnum + dd); }
	/*int*/long operator-(const Date& dt) const	{ return /*(int)*/(julnum - dt.julnum); }
	Date operator-(int dd) const		{ return Date(julnum - dd); }
	void operator+=(int dd)			{ julnum += dd; }
	void operator-=(int dd)			{ julnum -= dd; }
	bool between(const Date& d1, const Date& d2) const {
		return julnum >= d1.julnum && julnum <= d2.julnum;
	}
	dayTy day() const;
	dayTy dayOfMonth() const;
	dayTy firstDayOfMonth() const		{ return firstDayOfMonth(month()); }
	dayTy firstDayOfMonth(monthTy month) const;
	bool leap() const;
	Date max(const Date& dt) const { 
	        if (dt.julnum > julnum) return dt;
		else return *this;
        }
	void mdy(monthTy&,dayTy&,yearTy&) const;
	Date min(const Date& dt) const {
	        if (dt.julnum < julnum) return dt;
		else return *this;
        }
	monthTy	month() const;
	const char* nameOfMonth() const;
	Date previous(const char* dayName) const;
	dayTy weekDay() const;
	yearTy year() const;
	virtual int /*long*/ compare(const Object&) const;
	virtual void deepenShallowCopy();	// {}
	virtual unsigned long hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual void scanFrom(istream& strm);
	virtual const Class* species() const;
};

#endif
