#ifndef ERRORSH
#define ERRORSH



/* MSDOS revisions Michael F. Murphy 1993
 * FAC_MASK, OFFSET_MASK constants as long
 * FACILITY_CODE, OFFSET_INDEX functions as long
 * MAX_FACILITIES = 1
 * casts
 */

#include <stdio.h>
#include <iostream.h>

const int MAX_MSG_ARG =	8;      /* max numbers of args per msg */
// MFM
//const int MAX_FACILITIES = 32;  /* max no. of facilities */
const int MAX_FACILITIES = 1;  /* max no. of facilities */
const int SYS_LAST_ERROR = 34;	/* last UNIX system error */

/* Error Code Definition */
const int FAC_SHIFT =    12;	    // right shift count to get facility code
//const int OFFSET_MASK =  0xfff;     // mask for offset portion of error
//const int FAC_MASK =     0xfff000;  // mask for facility portion
// MFM
const long OFFSET_MASK =  0x0000fffL;  // mask for offset portion of error
const long FAC_MASK =     0xffff000L;  // mask for facility portion

//inline int FACILITY_CODE(int ER) { return ((ER&FAC_MASK)>>FAC_SHIFT); }
//inline int OFFSET_INDEX(int ER)  { return (ER&OFFSET_MASK); }
// MFM
inline int FACILITY_CODE(long ER) { return (int)((ER&FAC_MASK)>>FAC_SHIFT); }
inline int OFFSET_INDEX(long ER)  { return (int)(ER&OFFSET_MASK); }

class ErrSpecs {
public:
	int severity;		/* severity of this error */
	char* args;		/* error msg args: I=int, S=string,D=double */
	char* text;		/* printf format string for error text */
	};


class ErrFac {
public:
typedef enum { 
	SUCCESS = 0,
	INFORMATION = -1,
	INFO = -1,
	WARNING = -2,
	ERROR = -3,
	FATAL = -4,
	DEFAULT = 1 } severity_level;

	char* longname;		/* facility long name for the error msgs */
	ErrSpecs* errlist;	/* all errors for this facility */
	int last;		/* last error in this facility */
};

extern "C" {
void seterropt(int esev, int psev, int dump, int fmt, FILE*);
void geterropt(int& esev,int& psev,int& dump,int& fmt,FILE*&);
int seterror(int err, int sev, ...);

ErrFac* errfac_at(int err);
int errfac_severity(int err);
char* errfac_errorText(int err, char* buf =0);
void errfac_prepText(char* p, char* q);
void errfac_prepNextArg(char* p,char* q);
char* errfac_argumentCodes(int err);
void errfac_errorMessage(int sev,char* msg);
int errfac_printSeverity();
int errfac_exitSeverity();
int errfac_isPrintSeverity(int s);
int errfac_isExitSeverity(int s);
}
#endif /* ERRORSH */
