#ifndef	EXCEPTION_H
#define	EXCEPTION_H

/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */
/* Exception.h,v 3.12 92/07/26 14:32:15 */

/* 
 * Borland no inline in friend declaration
 */

#include "nihclstd.h"
#pragma hdrstop  

class ExceptionAction : public NIHCL {
public:			// type definitions
	enum exceptionActionTy { ABORT, RAISE };
private:
	unsigned error_code;
	exceptionActionTy old_action;
protected:
	ExceptionAction(unsigned error);
	virtual ~ExceptionAction();
};

class RaiseException : public ExceptionAction {
public:
	RaiseException(unsigned error);
};

class AbortException : public ExceptionAction {
public:
	AbortException(unsigned error);
};


class ExceptionTrap : public NIHCL {
public:			// type definitions
	typedef void (*exceptionTrapTy)(unsigned&, int&);
private:
	exceptionTrapTy old_trap;
public:
	ExceptionTrap(exceptionTrapTy xtrap =NULL);
	~ExceptionTrap();
};

class Process;
class Catch;

class ExceptionEnv : public NIHCL {
private:		// static member variables
	static ExceptionEnv* stackTop;
	static ExceptionEnv* lastResort;
	friend Catch;
#ifndef __BCPLUSPLUS__
	inline
#endif
	friend void RAISE(int exception);
	friend Process;
private:
	ExceptionEnv* prev;
	int exceptionCode;
	jmp_buf env;
public:  
	// Symptoms of failure to inline:
	//	MSC - Runtime error R6003 integer divide by 0
	// BCC -  
#pragma -vi	
	ExceptionEnv() {	// MUST be inline
		prev = stackTop;
		stackTop = this;
		exceptionCode = setjmp(env);
	}       
#pragma -vi.	
	~ExceptionEnv() { if (stackTop == this) pop(); }
	int code() const { return exceptionCode; }
	void pop()	{ stackTop = prev; }
	void raise(int exception);
};

#define	EXCEPTION_CODE	exception_environment.code()

#define BEGINX { \
	ExceptionEnv exception_environment; \
	if (EXCEPTION_CODE == 0) { \
		
// Statements in the scope of this exception handler block go here.

#define EXCEPTION \
	} \
	else switch(EXCEPTION_CODE) { \

/*
Exception handlers go here; the syntax is that of a switch statement
body.  The exception code that caused this EXCEPTION block to be entered
may be accessed via the macro EXCEPTION_CODE.  The statement
"default:RAISE(EXCEPTION_CODE);" will propagate the current exception up
to the next exception handler block if the exception is not handled by
this block; otherwise, execution continues with the first statement
after this exception block.
*/

#define ENDX \
	}; \
} \

inline void RAISE(int exception)
{
	ExceptionEnv::stackTop->raise(exception);
}

class Catch : public NIHCL {
	static Catch* stackTop;	// top of catch frame stack
	friend Process;
private:
	Catch*	next;
	Catch*	prev;
	Object*	obj;
	friend ExceptionEnv;
public:
	Catch(Object*);
	Catch();		// for construction of catch_stack_top only!
	~Catch();
};

#endif
