#ifndef	INTEGER_H
#define	INTEGER_H

/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */
/* Integer.h,v 3.11 92/07/26 14:32:30 */

#include "nihclstd.h"
#pragma hdrstop


class Integer: public VIRTUAL Object {
	DECLARE_MEMBERS(Integer);
	long val;
	void parseInteger(istream& strm)	{ strm >> val; }
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Integer(long v =0)		{ val = v; }
	Integer(istream&);
	long value() const		{ return val; }
	long value(long newval)		{ return val = newval; }
	virtual int compare(const Object&) const;
	virtual void deepenShallowCopy();	// {}
	virtual unsigned long hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual void scanFrom(istream& strm);
	virtual const Class* species() const;
};

#endif
