#ifndef	ITERATOR_H
#define	ITERATOR_H
            
/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */            
/* Iterator.h,v 3.12 92/07/26 14:32:32 */

#include "nihclstd.h"
#pragma hdrstop


class Collection;

class Iterator: public VIRTUAL Object {
	DECLARE_MEMBERS(Iterator);
	const Collection* cltn;	// Collection being iterated over
public:
	unsigned int index;		// index of next Object  (unsigned - MFM)
	Object*	ptr;				// pointer to current Object or NULL
	unsigned num;				// object number, used by Bags
	Object*	state;			// additional state, e.g., a Stack
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Iterator(const Collection&);
#if defined(MIBADDEFAULTFCNS)
	Iterator(const Iterator& copyfrom);
	Iterator& operator=(const Iterator& rhs);
#endif
	~Iterator();
	void reset();											// reset to beginning of Collection
	Object*	operator()() const { return ptr; }	// return current object pointer
	Object* operator++(); 								// advance to next object in Collection 
	Object* operator++(int) { return this->operator++(); } 
	const Collection* collection() const	{ return cltn; }
	bool operator==(const Iterator&) const;
	bool operator!=(const Iterator& a) const { return !(*this==a); }
	virtual void deepenShallowCopy();				// copy with cltn->deepCopy()
	virtual void dumpOn(ostream& strm =cerr) const;
	virtual unsigned long hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual const Class* species() const;
private:				// shouldNotImplement()
	virtual	int compare(const Object&) const;
};


// throw in  a NULL here to quiet compilers - MFM
#define DO(cltn,cls,arg)\
{ cls* arg;\
Iterator DO_pos(cltn);\
while ((arg = cls::castdown(DO_pos++)) != NULL) {

#define OD }}

#endif
