#ifndef  NIHCLCONFIG_H
#define  NIHCLCONFIG_H
/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: */
/* nihclconfig.h,v 3.13 92/12/19 15:42:34 */

#ifdef _MSC_VER
/* shut off unknown pragma warnings */
#pragma warning (disable: 4068 4084)
/* shut off precompiled header notices */
#pragma warning (disable: 4699)
// just fix it
#ifdef NULL
#undef NULL 
#endif
#define NULL 0UL
#endif


#if defined(__MSDOS__) || defined(_MSDOS) || defined(_DOS) 
// An app specific identifier
#define __MS_DOS__           
#define USEINT16
#endif

#if defined(__BCPLUSPLUS__) || defined(_MSC_VER)
// Common configuration
#define STACK_GROWS_DOWN 1 

// Common problems
// Borland complains
// MSC is silent but screws up in many(but not all) of the same places , fix is harmless
#define REFTOTEMP   

// Vendor specific problems           

#ifdef __BCPLUSPLUS__ 
// Seems as if the default versions generated by compiler are flaky
// Need to write versions of assignment operator and copy constructor
#define BADDEFAULTFCNS  
// Address of a particular static object not available at object construction  
// [An exceedingly gray area of the language: What does "first use" actually mean? - MFM]
#define ADDRSTATICOBJECT
// check this in SortedCltn, left over?
#define MAXASARG
#if defined(MI)                
// With multiple inheritance more goofiness occurs
// Seems as if the default versions generated by compiler are flaky
// Need to write versions of assignment operator and copy constructor
#define MIBADDEFAULTFCNS
#endif /* MI */
#endif /* __BCPLUSPLUS__ */

#ifdef _MSC_VER 
// Functions overloaded on references compile fine, they just crash, e.g., Class::reader
#define NOOVERLOADONREF
// Even with large model can't always get the right behavior to ,... function
#define BADVARARGSNULL      
// no implict cast to const
#define NOCONSTCAST
#if defined(MI)
// Linker error - pure virtuals unresolved 
// Clever - functions the compiler allows not to exist are required by linker 
// Probably a generalized condition; this handles cases in test and examples suites
#define LINKPUREVIRT 
#define MIBADDEFAULTFCNS 
#define BADDEFAULTFCNS  
#endif /* MI */

#endif /* _MSC_VER */

#endif  /* defined(__BCPLUSPLUS__) || defined(_MSC_VER) */         




inline unsigned mod_sizeof_short(unsigned i) {
  return sizeof(short)&sizeof(short)-1 ? i%sizeof(short) : i&sizeof(short)-1; }
inline unsigned mod_sizeof_int(unsigned i)   {
  return sizeof(int)&sizeof(int)-1 ? i%sizeof(int) : i&sizeof(int)-1; }
inline unsigned mod_sizeof_long(unsigned i)  {
  return sizeof(long)&sizeof(long)-1 ? i%sizeof(long) : i&sizeof(long)-1; }
inline unsigned mod_sizeof_float(unsigned i) {
  return sizeof(float)&sizeof(float)-1 ? i%sizeof(float) : i&sizeof(float)-1; }
inline unsigned mod_sizeof_double(unsigned i)   {
  return sizeof(double)&sizeof(double)-1 ? i%sizeof(double) : i&sizeof(double)-1; }
inline unsigned mod_sizeof_ptr(unsigned i)   {
  return sizeof(void*)&sizeof(void*)-1 ? i%sizeof(void*) : i&sizeof(void*)-1; }

#ifdef USEINT16
inline unsigned div_bitsize_char(unsigned i) { return i >> 3; }
inline unsigned mod_bitsize_char(unsigned i) { return i & 7; }

inline unsigned div_bitsize_int(unsigned i)  { return i >> 4; }
inline unsigned mod_bitsize_int(unsigned i)  { return i & 0xf;}

inline unsigned div_sizeof_short(unsigned i) { return i >> 1; }
inline unsigned div_sizeof_int(unsigned i)   { return i >> 1; }
inline unsigned div_sizeof_long(unsigned i)  { return i >> 2; }
inline unsigned div_sizeof_float(unsigned i) { return i >> 2; }
inline unsigned div_sizeof_double(unsigned i){ return i >> 3; }
inline unsigned div_sizeof_ptr(unsigned i)   { return i >> 2; }
#else
#error Fix bit twiddles
#endif /* USEINT16 */



const long UNINITIALIZED = 0xCCCCCCCC; // data value to flag uninitialized variables

// setjmp()/longjmp() context switching for Processes 
// see also HeapProc.cpp for additional machine-dependent code.

#ifdef USEINT16
typedef unsigned char       BYTE;
typedef unsigned short      WORD;
typedef unsigned long       DWORD;
typedef unsigned int        UINT;
typedef signed long         LONG;
#define LOBYTE(w)           ((BYTE)(w))
#define HIBYTE(w)           ((BYTE)((UINT)(w) >> 8))
#define LOWORD(l)           ((WORD)(l))
#define HIWORD(l)           ((WORD)((DWORD)(l) >> 16))
#define MAKELONG(low, high)  ((LONG)(((WORD)(low)) | (((DWORD)((WORD)(high))) << 16)))
#define MAKEULONG(low, high) ((DWORD)(((WORD)(low)) | (((DWORD)((WORD)(high))) << 16)))
#endif /* USEINT16 */


#if defined(__MS_DOS__) && defined(__BCPLUSPLUS__)
// The process hacks MUST be inline
#pragma -vi
#include <setjmp.h>
/*
typedef struct __jmp_buf {
	 unsigned    j_sp;
	 unsigned    j_ss;
	 unsigned    j_flag;
	 unsigned    j_cs;
	 unsigned    j_ip;
	 unsigned    j_bp;
	 unsigned    j_di;
	 unsigned    j_es;
	 unsigned    j_si;
	 unsigned    j_ds;
}   jmp_buf[1];
*/

typedef jmp_buf JMP_BUF;

inline int SETJMP(JMP_BUF env)   { return setjmp(env);}
inline void LONGJMP(JMP_BUF env, int val) { longjmp(env,val);}
inline int _SETJMP(JMP_BUF env)           { return SETJMP(env); }
inline void _LONGJMP(JMP_BUF env, int val){ LONGJMP(env,val); }

// segment is HIWORD
inline unsigned long GET_ENV_PC(const JMP_BUF& env)
	{ return MAKEULONG(env[0].j_ip, env[0].j_cs); }
inline unsigned long GET_ENV_SP(const JMP_BUF& env)
	{ return MAKEULONG(env[0].j_sp, env[0].j_ss); }
inline unsigned long GET_ENV_FP(const JMP_BUF& env)
	{ return MAKEULONG(env[0].j_bp,env[0].j_ss); }

// Clean out the temporaries after debugging - MFM */
inline unsigned long SET_ENV_PC(unsigned long cs_ip, JMP_BUF& env)
	{
	  unsigned int cs = HIWORD(cs_ip);
	  unsigned int ip = LOWORD(cs_ip);
	  env[0].j_cs = cs;
	  env[0].j_ip = ip;
	  return MAKEULONG(env[0].j_ip, env[0].j_cs);
	}
inline unsigned long SET_ENV_SP(unsigned long ss_sp, JMP_BUF& env)
	{
	  unsigned int ss = HIWORD(ss_sp);
	  unsigned int sp = LOWORD(ss_sp);
	  env[0].j_ss = ss;
	  env[0].j_sp = sp;
	  return MAKEULONG(env[0].j_sp, env[0].j_ss);
	}
inline unsigned long SET_ENV_FP(unsigned long ss_bp, JMP_BUF& env)
	{
	  unsigned int ss = HIWORD(ss_bp);
	  unsigned int bp = LOWORD(ss_bp);
	  env[0].j_ss = ss;
	  env[0].j_bp = bp;
	  return MAKEULONG(env[0].j_bp, env[0].j_ss);
	}       
// The process hacks MUST have been inline
#pragma -vi.      
/* End of Borland routines */    

#elif defined(_MSDOS) && defined(_MSC_VER) 
// Must compile with at least /Ob1 and /OV? (4 is OK lower limit unknown)
// N.B. /Od overrides /Ob so be careful when debugging

/* MSC does not define setjmp or longjmp with __cplusplus - a bit prematurely I'd say */
/* define the buffer type for holding the state information */

#define _JBLEN  9  /* bp, di, si, sp, ret addr, ds */

#ifndef _JMP_BUF_DEFINED
typedef  int  jmp_buf[_JBLEN];
#define _JMP_BUF_DEFINED
#endif 

#define setjmp  _setjmp
extern "C" int  __cdecl _setjmp(jmp_buf);
extern "C" void __cdecl longjmp(jmp_buf, int);


typedef jmp_buf JMP_BUF; 
inline int SETJMP(JMP_BUF env)            { return setjmp(env); }
inline void LONGJMP(JMP_BUF env, int val) { longjmp(env,val); }
inline int _SETJMP(JMP_BUF env)           { return SETJMP(env); }
inline void _LONGJMP(JMP_BUF env, int val){ LONGJMP(env,val); }

// segment is HIWORD
inline unsigned long GET_ENV_PC(const JMP_BUF& env)
	{ return MAKEULONG(env[4], env[5]); }
inline unsigned long GET_ENV_SP(const JMP_BUF& env)
	{ return MAKEULONG(env[3], env[6]); }
inline unsigned long GET_ENV_FP(const JMP_BUF& env)
	{ return MAKEULONG(env[0],env[6]); } 
	
// Get rid of temporaries after debugging */      
inline unsigned long SET_ENV_PC(unsigned long cs_ip, JMP_BUF& env)
	{
	  unsigned int cs = HIWORD(cs_ip);
	  unsigned int ip = LOWORD(cs_ip);
	  env[5] = cs;
	  env[4] = ip;
	  return MAKEULONG(env[4], env[5]);
	}
inline unsigned long SET_ENV_SP(unsigned long ss_sp, JMP_BUF& env)
	{
	  unsigned int ss = HIWORD(ss_sp);
	  unsigned int sp = LOWORD(ss_sp);
	  env[6] = ss;
	  env[3] = sp;
	  return MAKEULONG(env[3], env[6]);
	}
inline unsigned long SET_ENV_FP(unsigned long ss_bp, JMP_BUF& env)
	{
	  unsigned int ss = HIWORD(ss_bp);
	  unsigned int bp = LOWORD(ss_bp);
	  env[6] = ss;
	  env[0] = bp;
	  return MAKEULONG(env[0], env[6]);
	}  
#else
#error Unknown compiler for MSDOS
#endif /* recognized DOS compilers */

#endif /* NIHCLCON_H */
