#ifndef	OIO_H
#define	OIO_H

/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */
/* OIO.h,v 3.11 92/07/26 14:32:53 */

#include "nihclstd.h"
#pragma hdrstop

#include "OIOTbl.h"

class OIOin : public ReadFromTbl {
protected:
	Object* _readObject(const Class& cl) {
		return cl.readObject(*this);
	}
	virtual Object* readObject(const Class&) = 0;
	friend Object* Class::readFrom(OIOin&) const;
	friend Object* Class::readObject(OIOin&) const;
	friend Object::Object(OIOin&);
public:
	OIOin(unsigned size =1024) : ReadFromTbl(size) {}
	virtual OIOin& operator>>(char*) = 0;
	virtual OIOin& operator>>(char&) = 0;
	virtual OIOin& operator>>(unsigned char&) = 0;
	virtual OIOin& operator>>(short&) = 0;
	virtual OIOin& operator>>(unsigned short&) = 0;
	virtual OIOin& operator>>(int&) = 0;
	virtual OIOin& operator>>(unsigned int&) = 0;
	virtual OIOin& operator>>(long&) = 0;
	virtual OIOin& operator>>(unsigned long&) = 0;
	virtual OIOin& operator>>(float&) = 0;
	virtual OIOin& operator>>(double&) = 0;
	virtual int get() = 0;
	virtual OIOin& get(char&) = 0;
	virtual OIOin& get(unsigned char&) = 0;
	virtual OIOin& get(char*, unsigned size) = 0;
	virtual OIOin& get(unsigned char*, unsigned size) = 0;
	virtual OIOin& get(short*, unsigned size) = 0;
	virtual OIOin& get(unsigned short*, unsigned size) = 0;
	virtual OIOin& get(int*, unsigned size) = 0;
	virtual OIOin& get(unsigned int*, unsigned size) = 0;
	virtual OIOin& get(long*, unsigned size) = 0;
	virtual OIOin& get(unsigned long*, unsigned size) = 0;
	virtual OIOin& get(float*, unsigned size) = 0;
	virtual OIOin& get(double*, unsigned size) = 0;
	virtual OIOin& get(streambuf&, char delim ='\n') = 0;
	virtual OIOin& getCString(char*, unsigned maxlen) = 0;
	virtual int precision() = 0;
	virtual int precision(int) = 0;
	virtual int width() = 0;
	virtual int width(int) = 0;
};

class OIOout : public StoreOnTbl {
protected:
	void _storer(const Object& ob)	{ ob.storer(*this); }
	virtual void storeObject(const Object&) = 0;
	friend void Object::storeOn(OIOout&) const;
	friend void Object::storeMemberOn(OIOout&) const;
public:
	OIOout(unsigned size =256) : StoreOnTbl(size) {};
	virtual OIOout& operator<<(const char*) = 0;
	virtual OIOout& operator<<(char) = 0;
	virtual OIOout& operator<<(unsigned char) = 0;
	virtual OIOout& operator<<(short) = 0;
	virtual OIOout& operator<<(unsigned short) = 0;
	virtual OIOout& operator<<(int) = 0;
	virtual OIOout& operator<<(unsigned) = 0;
	virtual OIOout& operator<<(long) = 0;
	virtual OIOout& operator<<(unsigned long) = 0;
	virtual OIOout& operator<<(float) = 0;
	virtual OIOout& operator<<(double) = 0;
	virtual OIOout& put(char) = 0;
	virtual OIOout& put(const char* val, unsigned size) = 0;
	virtual OIOout& put(const unsigned char* val, unsigned size) = 0;
	virtual OIOout& put(const short* val, unsigned size) = 0;
	virtual OIOout& put(const unsigned short* val, unsigned size) = 0;
	virtual OIOout& put(const int* val, unsigned size) = 0;
	virtual OIOout& put(const unsigned int* val, unsigned size) = 0;
	virtual OIOout& put(const long* val, unsigned size) = 0;
	virtual OIOout& put(const unsigned long* val, unsigned size) = 0;
	virtual OIOout& put(const float* val, unsigned size) = 0;
	virtual OIOout& put(const double* val, unsigned size) = 0;
	virtual OIOout& putCString(const char*) = 0;
	virtual int precision() = 0;
	virtual int precision(int) = 0;
	virtual int width() = 0;
	virtual int width(int) = 0;
};

#endif /* OIO_H */
