#ifndef	RECTANGLE_H
#define	RECTANGLE_H

/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */
/* Rectangle.h,v 3.11 92/07/26 14:33:33 */

#include "nihclstd.h"
#pragma hdrstop

#include "Point.h"

class Rectangle: public VIRTUAL Object {
	DECLARE_MEMBERS(Rectangle);
	Point tl;		// top left corner (origin)
	Point br;		// bottom right corner (corner)
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Rectangle(int left=0, int top=0, int height=0, int width=0);
	Rectangle(const Point&, const Point&);
	Rectangle(const Rectangle&);
	Point origin() const		{ return tl; }
	Point origin(const Point& p)	{ return tl = p; }
	Point corner() const		{ return br; }
	Point corner(const Point& p)	{ return br = p; }
	Point topLeft() const		{ return tl; }
	Point topCenter() const		{ return Point((br.x()+tl.x())/2,tl.y()); }
	Point topRight() const		{ return Point(br.x(),tl.y()); }
	Point rightCenter() const	{ return Point(br.x(),(br.y()+tl.y())/2); }
	Point bottomRight() const	{ return br; }
	Point bottomCenter() const	{ return Point((br.x()+tl.x())/2,br.y()); }
	Point bottomLeft() const	{ return Point(tl.x(),br.y()); }
	Point leftCenter() const	{ return Point(tl.x(),(br.y()+tl.y())/2); }
	Point center() const		{ return Point((br.x()+tl.x())/2,(br.y()+tl.y())/2); }
	Point extent() const		{ return Point(br.x()-tl.x(),br.y()-tl.y()); }
	int area() const		{ return (br.x()-tl.x())*(br.y()-tl.y()); }
	int width() const		{ return br.x()-tl.x(); }
	int height() const		{ return br.y()-tl.y(); }
	bool operator==(const Rectangle&) const;
	bool operator!=(const Rectangle& r) const	{ return !(*this==r); }
	Rectangle operator&&(const Rectangle&) const;	// intersection 
	Rectangle operator||(const Rectangle&) const;	// union 
	void operator+=(const Point&);			// translate 
	void operator-=(const Point&);
	bool contains(const Point&) const;
	bool contains(const Rectangle&) const;
	bool intersects(const Rectangle&) const;
	void moveTo(const Point&);
	virtual void deepenShallowCopy();	// {}
	virtual unsigned long hash() const;
	virtual bool isEqual(const Object&) const;	// equality test 
	virtual void printOn(ostream& strm =cout) const;
	virtual const Class* species() const;
private:			    // shouldNotImplement()
	virtual int compare(const Object&) const;
};

#endif
