/* Semaphore.c -- implementation of Semaphore



Objects of class Semaphore are used to synchronize Processes.

*/                 
#include "nihclstd.h"
#pragma hdrstop

#pragma -vi
#include "Semaphor.h"
#include "NIHProc.h"
#include "Schedule.h"
#include "nihclIO.h"

#define  THIS  Semaphore
#define  BASE  Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES LinkedList::desc()
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(Semaphore,1,"",NULL);

extern const int NIHCL_ASTBLK,NIHCL_DLSEMWAIT,NIHCL_CPSEMWAIT,NIHCL_STSEMWAIT;

Semaphore::Semaphore(int initialCount)
{
	count = initialCount;
}

Semaphore::Semaphore(const Semaphore& s) : waitList(s.waitList)
{
	count = s.count;
}

void Semaphore::signal(unsigned n)
{
	if (n == 0) return;
		Process* next;
		while (count<0 && n>0) {
			next = Process::castdown(waitList.removeFirst());
			if (next->state() != Process::TERMINATED) {
				next->resume();
				n--;
			}
			count++;
		}
		count += n;
}

void Semaphore::wait()
{
		if (--count < 0) {
			Scheduler::activeProcess().suspend();
			waitList.addLast(Scheduler::activeProcess());
		}
	if (count < 0) Scheduler::schedule();
}

Semaphore::~Semaphore()
{
	if (count<0) setError(NIHCL_DLSEMWAIT,DEFAULT,-count,this,className());
}

Object* Semaphore::copy() const  { return deepCopy(); }

void Semaphore::deepenShallowCopy()
{
	if (count < 0) setError(NIHCL_CPSEMWAIT,DEFAULT,-count,this,className());
}

unsigned long Semaphore::hash() const  { return (unsigned long)this; }

bool Semaphore::isEqual(const Object& ob) const { return isSame(ob); }

void Semaphore::dumpOn(ostream& strm) const
{
	strm << className() << "[count: " << count << '\n';
	DO(waitList,Process,p) p->dumpOn(strm); OD
	strm << "]\n";
}

void Semaphore::printOn(ostream& strm) const
{
	strm << "count: " << count;
	if (count < 0) strm << "  waitList:";
	DO(waitList,Process,p) strm << ' ' << *p; OD
}

bool Semaphore::includes(const Process& p) const
{
	bool i = waitList.includes(p);
	return i;
}

Process* Semaphore::remove(Process& p)
{
	if (count < 0 && waitList.includes(p)) {
		waitList.remove(p);
		++count;
		return &p;
	}
	else {
		return /*NULL*/0UL;
	}
}

Process* Semaphore::removeFirst()
{
	if (count < 0) {
		Process* p = Process::castdown(waitList.removeFirst());
		++count;
		return p;
	}
	else {
		return /*NULL*/0UL;
	}
}

Process* Semaphore::removeLast()
{
	if (count < 0) {
		Process* p = Process::castdown(waitList.removeLast());
		++count;
		return p;
	}
	else {
		return /*NULL*/0UL;
	}
}

int Semaphore::value() const  { return count; }

Semaphore::Semaphore(OIOin& strm)
	: BASE(strm)
{
	strm >> count;
}

void Semaphore::storer(OIOout& strm) const
{
	if (count < 0) setError(NIHCL_STSEMWAIT,DEFAULT,-count,this,className());
	BASE::storer(strm);
	strm << count;
}

Semaphore::Semaphore(OIOifd& fd)
	: BASE(fd)
{
	fd >> count;
}

void Semaphore::storer(OIOofd& fd) const
{
	if ( count < 0 )
		setError(NIHCL_STSEMWAIT,DEFAULT,-count,this,className());
	BASE::storer(fd);
	fd << count;
}

int Semaphore::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}
