#ifndef	SEMAPHORE_H
#define	SEMAPHORE_H
       
/*NIH class library for MS-DOS 4/93 Michael F. Murphy*/
/*UNIX source:*/         
/*Semaphore.h,v 3.11 92/07/26 15:45:28*/


#include "nihclstd.h"
#pragma hdrstop  

#pragma -vi

#include "Object.h"
#include "LinkedLi.h"


class Process;

class Semaphore: public VIRTUAL Object {
	DECLARE_MEMBERS(Semaphore);
	LinkedList waitList;
	short count;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Semaphore(int initialCount =0);
	Semaphore(const Semaphore&);
	~Semaphore();
	virtual Object* copy() const;		// deepCopy()
	virtual void deepenShallowCopy();
	virtual void dumpOn(ostream& strm =cerr) const;
	virtual unsigned long hash() const;
	virtual bool includes(const Process&) const;
	virtual bool isEqual(const Object& ob) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual Process* remove(Process&);
	virtual Process* removeFirst();
	virtual Process* removeLast();
	virtual void signal(unsigned n=1);  // signal waiting process 
	virtual int value() const;	// read semaphore value 
	virtual void wait();		// wait on semaphore 
private:			    // shouldNotImplement()
	virtual int compare(const Object&) const;
};

#endif /* SEMAPHORE_H */
