#ifndef STACKPROC_H
#define STACKPROC_H

/* StackProc.h -- Specification for Process with stack shared with main() process


*/
/* MSDOS revisions - Michael Murphy 1993
 * undo include <nihcl..
 * stacksize as int
 */


#include "nihclstd.h"
#pragma hdrstop
 
#pragma -vi 
#include <malloc.h> 

#include "NIHProc.h"


class Scheduler;

class StackProc: public Process {
	DECLARE_MEMBERS(StackProc);
public:
	stackTy* stack_top;		// pointer to stack top -- public for MAIN_PROCESS
private:
	stackTy* stack_save;		// stack save area
	unsigned /*long*/ stack_save_size;	// size of stack save area in words

	StackProc(stackTy* bottom, int priority);	// MAIN process constructor 
	void saveStack();
	friend Scheduler;	// friend void Scheduler::initialize(stackTy* \*bottom\*, int \*priority*\)
public:
	void restoreStack(const stackTy*);	// public so MAIN_PROCESS macro can access
protected:
	StackProc(const char* name, stackTy* bottom,
				int priority =0, unsigned /*long*/ size =0);
	virtual void switchContext(Process*);
	virtual void switchFrom(HeapProc*);
	virtual void switchFrom(StackProc*);
#pragma -vi
	bool FORK() {
		add();		// add this process to Scheduler runlist
		return (_SETJMP(proc_env) == 0);
	}
protected:		// storer() functions for object I/O
	virtual	void storer(OIOofd&) const	{ shouldNotImplement("storer"); }
	virtual	void storer(OIOout&) const	{ shouldNotImplement("storer"); }
public:
	virtual	void deepenShallowCopy()	{ shouldNotImplement("deepenShallowCopy"); }
public:
	~StackProc();
	virtual unsigned size() const;
};

#endif
