// ex11-3.c -- Protecting a critical section of code
//             with an AutoSignal

#define BASE HeapProc
#if BASE == StackProc
#include "StackPro.h"
#endif
#if BASE == HeapProc
#include "HeapProc.h"
#endif

#include "Scheduler.h"
#include "Semaphore.h"
#include "NIHStrin.h"

static Semaphore protect_critical(1);

class AutoSignal {
    Semaphore* as;
public:
    AutoSignal(Semaphore& s) { as= &s; as->wait(); }
    ~AutoSignal() { as->signal(); }
};

class TestProcess : public BASE {
public:
    TestProcess(const char* name, stackTy* bot, int pri);
    static TestProcess* create(const char* name, int pri);
};

TestProcess::TestProcess(const char* pname,stackTy* bot,int pri)
            : BASE(pname,bot,pri)
{
    // parent process yields to allow this process to start
    if ( FORK() ) { Scheduler::yield(); return; }

    while (1) {
        // this block represents a critical section
        // although it does nothing critical
        AutoSignal autosig(protect_critical);
        cout << name() << pri << " enter critical section" << endl;
        break;
        }

    // terminate to avoid return
    terminate();
}

TestProcess* TestProcess::create(const char* name, int pri)
{
    // the next two statements must be in the same scope
    // for the address of the stack bottom to be correct
    auto Process::stackTy bottom;
    return new TestProcess(name,&bottom,pri);
}

void main()
{
    // start Scheduler
    // create main context with priority 0
    MAIN_PROCESS(0);

    String* pname = new String("P"); 
    for (register int i=MAXPRIORITY; i>=1; i--)
        TestProcess::create(*pname,i);

    cout << "main Process" << endl;
}
