/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: */
/* AssocInt.c,v 3.13 92/12/19 15:52:47 */ 

#include "nihclstd.h"
#pragma hdrstop

#include <AssocInt.h>
#include <nihclIO.h>

#define	THIS	AssocInt
#define	BASE	LookupKey
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES Integer::desc()
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(AssocInt,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

AssocInt::AssocInt(Object& newKey, int newValue)
	: BASE(newKey), avalue(newValue)
{
}

#ifdef BADDEFAULTFCNS
AssocInt::AssocInt(const AssocInt& copyfrom): BASE(copyfrom),
	avalue(copyfrom.avalue)
{
}

AssocInt& AssocInt::operator=(const AssocInt& rhs)
{
	if(this ==&rhs)
		return *this;

	BASE::operator=(rhs);

	avalue = rhs.avalue;
	return *this;
}
#endif

Object* AssocInt::value() { return &avalue; }

const Object* AssocInt::value() const { return &avalue; }

Object* AssocInt::value(Object& newValue)
{
	assertArgClass(newValue,*Integer::desc(),"value");
	avalue = Integer::castdown(newValue);
	return &avalue;
}

void AssocInt::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	avalue.deepenShallowCopy();
}

static int intval;

AssocInt::AssocInt(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm),
	avalue((strm >> intval, intval))
{
}

void AssocInt::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << avalue.value();
}

AssocInt::AssocInt(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd),
	avalue((fd >> intval, intval))
{
}

void AssocInt::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << avalue.value();
}
