/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: */ 
/* Bitset.c,v 3.13 92/12/19 15:52:52 */
#include "nihclstd.h"
#pragma hdrstop

#include <Bitset.h>
#include <nihclIO.h>

#define	THIS	Bitset
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(Bitset,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

unsigned Bitset::capacity() const	{ return sizeof(int)*8; }

void Bitset::deepenShallowCopy()	{}

unsigned long Bitset::hash() const	{ return m; }
	
bool Bitset::isEmpty() const	{ return m==0; }
	
bool Bitset::isEqual(const Object& ob) const
{
	return ob.isSpecies(classDesc) && *this==castdown(ob);
}

const Class* Bitset::species() const { return &classDesc; }

void Bitset::printOn(ostream& s) const
{
	Bitset t = *this;
	for (unsigned i =0; i<capacity() && !t.isEmpty(); i++) {
		if (t.includes(i)) {
			s << i;
			t -= i;
			if (!t.isEmpty()) s << ',';
		}
	}
}

unsigned Bitset::size() const
{
	unsigned l=m;
	unsigned n=0;
	while (l != 0) {
		l &= (l-1);	// removes rightmost 1 
		n++;
	}
	return n;
}

Bitset::Bitset(OIOin& strm)
	: BASE(strm)
{
	strm >> m;
}

void Bitset::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << m;
}

Bitset::Bitset(OIOifd& fd)
	: BASE(fd)
{
	fd >> m;
}

void Bitset::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << m;
}

int Bitset::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}
