/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: */      
/* Class.c,v 3.16 92/12/19 15:36:41 */

#include "nihclstd.h"
#pragma hdrstop
 
#include <assert.h>  
#include <stdarg.h>

#include "NIHStrin.h"
#include "Dictiona.h"
#include "Assoc.h"
#include "OrderedC.h"
#include "IdentSet.h"
#include "nihclIO.h"
#include "OIOTbl.h"

extern const int NIHCL_RDBADSIG,NIHCL_RDBADTYP,NIHCL_RDWRONGCLASS,NIHCL_RDUNKCLASS;

#define  THIS  Class
#define  BASE  Object
#define  BASE_CLASSES   BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()      


/* DEFINE_CLASS */

Object* Class::reader(OIOin&)
{
	setError(NIHCL_RDUNKCLASS,DEFAULT,"Class");
	return NULL;
} 

#ifdef NOOVERLOADONREF 
Object* Class::binreader(OIOifd&)
{
	setError(NIHCL_RDUNKCLASS,DEFAULT,"Class");
	return NULL;
}
#else 
Object* Class::reader(OIOifd&)
{
	setError(NIHCL_RDUNKCLASS,DEFAULT,"Class");
	return NULL;
}
#endif
                     
#if defined(NOOVERLOADONREF) && defined(BADVARARGSNULL)                     
static Class class_Class("Class",
	ClassList(0UL,BASE_CLASSES,0UL), ClassList(0UL,0UL), ClassList(0UL,0UL),  
	1, // version
	"$"__FILE__" "__DATE__" "__TIME__"$",
	sizeof(Class), Class::reader, Class::binreader, NULL );
#else
static Class class_Class("Class",
	ClassList(NULL,BASE_CLASSES,NULL), ClassList(NULL,NULL), ClassList(NULL,NULL),  
	1, // version
	"$"__FILE__" "__DATE__" "__TIME__"$",
	sizeof(Class), Class::reader, Class::reader, NULL );
#endif	

const Class* Class::desc() { return &class_Class; }

const Class* Class::isA() const  { return &class_Class; }

Object* Class::shallowCopy() const  { return new Class(*this); }

_DEFINE_CASTDOWN(Class)

// head of the list of all Classes
// built by the static constructor of class Class 
static Class* allClasses =NULL;

// Dictionary of all Classes 
static Dictionary* classDictionary =NULL;
const Dictionary& Class::dictionary()
{
	 if ( classDictionary==NULL ) {
		  classDictionary = new Dictionary;
		  for ( Class* clp = allClasses; clp; clp=clp->nextClass )
#ifdef TRACE
{
cout << "dictionary(): adding " << clp->name() << " to class Dictionary" << endl;
		clp->dumpOn(cout);
#endif
		 classDictionary->add(*new Assoc(*new String(clp->name()), *clp));
#ifdef TRACE
}
#endif
	 }
	 return *classDictionary;
}

// Added some TRACE facilities
// A usual suspect - MFM
ClassList::ClassList(const char* arg0, ...)
{
	va_list ap;
#if defined(__BCPLUSPLUS__)
	(void)arg0;    // shut up compiler
#endif
	unsigned nargs = 0;
	va_start(ap, arg0);
	do nargs++; while (va_arg(ap, Class*));
	va_end(ap); 
#ifdef TRACE
	cout << "ClassList() arg count " << nargs << endl;
#endif		
	Class** p = clp = new Class*[nargs];
	va_start(ap, arg0);
	while (nargs--) { 
		*p++ = va_arg(ap, Class*);    
#ifdef TRACE
		cout << "ClassList() " << (void*)(*(p-1)) << endl;
#endif				
	}  
	va_end(ap);
}

Class::Class(const char* name,
	const ClassList& bases, const ClassList& members, const ClassList& vbases,
	unsigned version, const char* ident, unsigned size,
	Object* (*reader)(OIOin&),
	Object* (*binreader)(OIOifd&),
	initorTy initor )
:  
	class_name(name),
	class_ident(ident),
#if !defined(NOCONSTCAST) 
	class_bases(bases.clp),
	class_members(members.clp),
	class_vbases(vbases.clp),
#else 
// Workaround _MSC_VER problem with casting Foo** to const Foo**
	class_bases((const Class**)bases.clp),
	class_members((const Class**)members.clp),
	class_vbases((const Class**)vbases.clp),
#endif
	class_version(version),
	inst_size(size),
	inst_reader(reader),
	inst_binreader(binreader)
{                                 
	nextClass = allClasses; allClasses = this;
#ifdef TRACE
cout << "prepending " << name << " to allClasses" << endl;
#endif
	class_signature = 0UL;
	class_number = 0;   
	
// if (initor != 0) initor(*this);  MASSCOMP cc bug
	initorTy initfun = initor;
	if (initfun != NULL) initfun(*this);
}

Class::Class(const Class& c)
:
	class_name(c.class_name),
	class_bases(c.class_bases),
	class_members(c.class_members),
	class_vbases(c.class_vbases),
	class_version(c.class_version),
	class_ident(c.class_ident),
	class_signature(c.class_signature),
	inst_size(c.inst_size),
	inst_reader(c.inst_reader),
	inst_binreader(c.inst_binreader),
	class_number(c.class_number)
{
}

int Class::compare(const Object& ob) const   // compare Class names 
{
	assertArgSpecies(ob,class_Class,"compare");
	return strcmp(name(),castdown(ob).name());
}

unsigned long Class::hash() const   { return (const unsigned long)this; }

bool Class::isEqual(const Object& ob) const  { return this == castdown(&ob); }

bool Class::_isKindOf(const Class& clid) const
{
	 if (this == &clid) return YES;
	 const Class** bp = baseClasses();
	 assert(bp);
	 while (*bp) if ((*bp++)->_isKindOf(clid)) return YES;
	 return NO;
}

void Class::deepenShallowCopy()  { shouldNotImplement("deepenShallowCopy"); }

void Class::dumpOn(ostream& strm) const
{
	strm << className() << '[' << name() << endl;
	strm << "ident: " << ident() << endl;
	strm << "version: " << version() << endl;
	strm << "signature: " << signature() << endl;
	strm << "number: " << number() << endl;
	strm << "base classes:";
	const Class** p = baseClasses();
	while (*p) strm << ' ' << (*p++)->name();
	strm << endl;
	strm << "member classes:";
	p = memberClasses();
	while (*p) strm << ' ' << (*p++)->name();
	strm << endl;
	strm << "virtual base classes:";
	p = virtualBaseClasses();
	while (*p) strm << ' ' << (*p++)->name();
	strm << endl;
	strm << "]" << endl;
}

void Class::printOn(ostream& strm) const  { strm << class_name; }

unsigned Class::size() const  { return inst_size; }
	
void Class::addSignature(unsigned long s)
{
// Assumes that an unsigned long is at least 32 bits
	class_signature = ((class_signature << 3) + ((class_signature >> (32-3)) & 7) + s) & 0xFFFFFFFFL;
}

// computeSignature assumes signatures never computed from static constructors
// so that all class descriptor are already initialized 
void Class::computeSignature()
{     
// Hack for C8  
#if defined(_MSC_VER) && defined(_FAST)
	if(this == 0UL) {
		cerr << "this == 0UL! in Class::computeSignature() Did you try /f?" << endl;
		abort();
	}		
#endif 

	if (this == Object::desc()) {
		class_signature = class_version;
		return;
	}                               
    
//	compute signature 
	assert(class_bases);  
	Class** p = (Class**)class_bases;
	while (*p) {
		addSignature((*p++)->signature());  
	}	
	if (class_signature == 0UL) class_signature++;   
	
	assert(class_members);
	p = (Class**)class_members;
	while (*p) {
		addSignature((*p++)->signature()); 
	}	
	if (class_version != 0) addSignature(class_version);
	if (class_signature == 0UL) class_signature++;   
}

const Class* Class::lookup(const char* name)
// Find the class descriptor for class "name"
{
	LookupKey* asc = dictionary().assocAt(String(name));
	if (asc == NULL) return NULL;
	return castdown(asc->value());
}

class ReadFromTblMgr { 
#ifdef _MSC_VER    
	// declared but not defined - quiet compiler
	ReadFromTblMgr& operator=(const ReadFromTblMgr&);  
#endif
	ReadFromTbl& tbl;
	friend Object* Class::readFrom(OIOin& strm) const;
	friend Object* Class::readFrom(OIOifd& fd) const;
	ReadFromTblMgr(ReadFromTbl& t) : tbl(t) {
		if (tbl.level++ == 0) tbl.reset();
	}
	~ReadFromTblMgr() { --tbl.level; }
};

Object* Class::readFrom(OIOin& strm) const
{
	ReadFromTblMgr mgr(strm);
	return strm.readObject(*this);
}

Object* Class::readObject(OIOin& strm) const
// Called by OIOin::readObject()
{
#ifdef DEBUG_OBJIO
	cerr << "readFrom: read instance of class " << name();
#endif
	strm.addObjectEnable();
	const Class* saveClass = strm.readFromClass(this); 
	assert(inst_reader);
	Object* target = (*inst_reader)(strm);
	strm.readFromClass(saveClass);
	return target;
}

Object* Class::readFrom(OIOifd& fd) const
{
	ReadFromTblMgr mgr(fd);
	return fd.readObject(*this);
}

Object* Class::readObject(OIOifd& fd) const
// Called by OIOifd::readObject()               
{
#ifdef DEBUG_OBJIO
	cerr << "readFrom: read instance of class " << name();
#endif
	fd.addObjectEnable();
	const Class* saveClass = fd.readFromClass(this); 
	assert(inst_binreader);
	Object* target = (*inst_binreader)(fd);
	fd.readFromClass(saveClass);
	return target;
}

void Class::storer(OIOout&) const { shouldNotImplement("storer"); }

void Class::storer(OIOofd&) const { shouldNotImplement("storer"); }
