/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: IdentDict.c,v 3.14 92/12/19 15:53:06  */
/*
Function:
	
An IdentDict is like a Dictionary, except keys are compared using
isSame() rather than isEqual().
*/
#include "nihclstd.h"
#pragma hdrstop
 
#include <assert.h> 

#include "IdentDic.h"
#include "LookupKe.h"
#include "nihclIO.h"

#define	THIS	IdentDict
#define	BASE	Dictionary
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(IdentDict,0,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

IdentDict::IdentDict(unsigned size) : BASE(size) {}

IdentDict::IdentDict(const IdentDict& c) : BASE(c) {}
  
// Need 16 bit index from address
#pragma warning (disable: 4305 4759)  
int IdentDict::findIndexOf(const Object& ob) const
/*
Search this IdentDict for a LookupKey with the same key object as the
argument.

Enter:
	ob = pointer to LookupKey to search for

Returns:
	index of object if found or of nil slot if not found
	
Algorithm L, Knuth Vol. 3, p. 519
*/
{
	int i;
	Object* keyob = LookupKey::castdown(ob).key(); 
	for (i = h((unsigned)keyob); contents[i]!=nil; i = (i-1)&mask) {
		if (LookupKey::castdown(contents[i])->key()->isSame(*keyob))
			return i;
	}
	return i;
}
#pragma warning (default: 4305 4759)  

unsigned long IdentDict::hashOf(const Object& ob) const
{
	return (unsigned long)LookupKey::castdown(ob).key();
}

Object* IdentDict::atKey(const Object& key) const
{
	return Dictionary::atKey(LookupKey((Object&)key));
}

Object* IdentDict::atKey(const Object& key, Object& newValue)
{
	return Dictionary::atKey(LookupKey((Object&)key), newValue);
}

LookupKey* IdentDict::assocAt(const Object& key) const
{
	return Dictionary::assocAt(LookupKey((Object&)key));
}

bool IdentDict::includesKey(const Object& key) const
{
	return Dictionary::includesKey(LookupKey((Object&)key));
}

IdentDict::IdentDict(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
	_reader(strm);
}

IdentDict::IdentDict(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)
{
	_reader(fd);
}
