/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: IdentSet.c,v 3.14 92/12/19 15:53:07 */

/*
Function:
	
An IdentSet is like a Set, except keys are compared using
isSame() rather than isEqual().
*/
#include "nihclstd.h"
#pragma hdrstop

#include "IdentSet.h"
#include "nihclIO.h"

#define	THIS	IdentSet
#define	BASE	Set
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(IdentSet,0,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

IdentSet::IdentSet(unsigned size) : BASE(size) {}

// Need 16 bit index from address
#pragma warning (disable: 4305 4759)
int IdentSet::findIndexOf(const Object& ob) const
/*
Search this IdentSet for the argument object.

Enter:
	ob = object to search for

Returns:
	index of object if found or of nil slot if not found
	
Algorithm L, Knuth Vol. 3, p. 519
*/
{
	int i;
	for (i = h((unsigned)&ob); contents[i]!=nil; i = (i-1)&mask) {
		if (contents[i]->isSame(ob)) 
			return i;
	}
	return i;
}
#pragma warning (default: 4305 4759)

unsigned long IdentSet::hashOf(const Object& ob) const
{
	return (unsigned long)&ob;
}

IdentSet::IdentSet(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
	_reader(strm);
}

IdentSet::IdentSet(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)
{
	_reader(fd);
}
