/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: Integer.c,v 3.13 92/12/19 15:53:07 */

#include "nihclstd.h"
#pragma hdrstop

#include "Integer.h"
#include "nihclIO.h"

#define	THIS	Integer
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(Integer,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

Integer::Integer(istream& strm)		{ parseInteger(strm); }

unsigned long Integer::hash() const { return val; }

bool Integer::isEqual(const Object& ob) const
{
	return ob.isSpecies(classDesc) && val==castdown(ob).val;
}

const Class* Integer::species() const { return &classDesc; }


int Integer::compare(const Object& ob) const
{
	assertArgSpecies(ob,classDesc,"compare");
	long t = val-castdown(ob).val;
#ifdef USEINT16
//	if (sizeof(long) > sizeof(int)) {
		if (t < 0) return -1;
		return (t > 0);
//	}
#else
	return t;
#endif
}


void Integer::deepenShallowCopy()	{}

void Integer::printOn(ostream& strm) const
{
	strm << val;
}

void Integer::scanFrom(istream& strm)	{ parseInteger(strm); }

Integer::Integer(OIOin& strm)
	: BASE(strm)
{
	strm >> val;
}

void Integer::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << val;
}

Integer::Integer(OIOifd& fd)
	: BASE(fd)
{
	fd >> val;
}

void Integer::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << val;
}
