/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: Link.c,v 3.13 92/12/19 */

/*
Function:
	
Link is an abstract class that is used to construct LinkedLists.  It
contains a pointer to the next Link in the list, or nil if this is the
last Link.
*/

/* 
 * Borland static init problem use Link::nilLink = NULL
 */
           
#include "nihclstd.h"
#pragma hdrstop
       
#include <assert.h>       
       
#include "Link.h"
#include "LinkOb.h"
#include "nihclIO.h"

#define	THIS	Link
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_ABSTRACT_CLASS(Link,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

extern const int NIHCL_DELLNK;
      
#if defined(LINKPUREVIRT)
bool Link::isEqual(const Object& /* pure_virtual*/) const
{
	assert(0);
	abort(); 
	return 0;
}

int Link::compare(const Object& /*pure_virtual*/) const
{     
	assert(0);
	abort(); 
	return 0;
}           

void Link::printOn(ostream& /*strm =cout pure_virtual*/) const
{
	assert(0);
	abort(); 
}     

unsigned long Link::hash() const
{
	assert(0);
	abort();
	return 0;
}	
#endif

#ifdef ADDRSTATICOBJECT
Link *const Link::nilLink = NULL;
#else
static LinkOb _nilLink;
Link *const Link::nilLink = &_nilLink;
#endif

Link::~Link()
{
	if (next != NULL) setError(NIHCL_DELLNK,DEFAULT,className(),next,this);
}

Object* Link::copy() const	{ return deepCopy(); }

void Link::deepenShallowCopy()
{
}

Link::Link(OIOifd& fd) : BASE(fd) { next = NULL; }

Link::Link(OIOin& strm) : BASE(strm) { next = NULL; }
