/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: OIOfd.c,v 3.11 92/07/26 14:32:58 */

#include "nihclstd.h"
#pragma hdrstop

#include <ctype.h>
#include "OIOfd.h"
#include "OIOTbl.h"

extern const int NIHCL_RDBADSIG,NIHCL_RDBADTYP,NIHCL_RDEOF,NIHCL_RDUNKCLASS,NIHCL_RDWRONGCLASS,NIHCL_READBINERR,NIHCL_READBINUNDFL,NIHCL_STOREBINERR,NIHCL_STROV;

// __BCPLUSPLUS__ buglet
#pragma warn -waus
Object* OIOifd::readObject(const Class& expectedClass)
{
	char recordType =-1;			// object I/O record type
	const Class* readClass = NULL;		// class descriptor pointer
	int objectNum;				// object reference number 
	unsigned classNum;		      // class reference number

// read record type byte from file descriptor
	*this >> recordType;
	
// parse object reference, class reference, or class name & signature
	switch (recordType) {
		case OIOofd::storeOnObjectRef: {	// read object reference
			*this >> objectNum;
#ifdef DEBUG_OBJIO
cerr << "readFrom: ref to object #" << objectNum
	<< ", class " << objectAt(objectNum)->className() << '\n';
#endif
			return objectAt(objectNum);
		}
		case OIOofd::storeOnClassRef: {		// read class reference
			unsigned /*short*/ classNum;  	// class reference number   /*short*/ MFM
			*this >> classNum;
#ifdef DEBUG_OBJIO
cerr << "readFrom: ref to class #" << classNum << ", class ";
#endif
			readClass = classAt(classNum);
#ifdef DEBUG_OBJIO
cerr << *readClass << '\n';
#endif
			break;
		}
		case OIOofd::storeOnClass: {		// read class name and class signature
			unsigned long signature;		// class signature 
			{
				char clsName[256];
				unsigned char namelen = 0;
				*this >> namelen;
				this->get(clsName,namelen);
				clsName[namelen] = '\0';
				*this >> signature;
				if ((readClass = Class::lookup(clsName)) == 0)
					setError(NIHCL_RDUNKCLASS, DEFAULT, clsName);
				if (!readClass->_isKindOf(expectedClass))
					setError(NIHCL_RDWRONGCLASS, DEFAULT, expectedClass.name(), clsName);
				if (readClass->signature() != signature)
				    setError(NIHCL_RDBADSIG, DEFAULT, clsName, readClass->signature(), signature);
			}
			classNum = (unsigned)add(readClass);			//(unsigned) MFM
#ifdef DEBUG_OBJIO
cerr << "readFrom: class " << *readClass << '\n';
#endif
			break;
		}
		default: setError(NIHCL_RDBADTYP,DEFAULT,recordType,fd);
	}

// call class object reader to read object
	return readClass->readObject(*this);
} /* Borland - classNum assigned value not used - MFM */
#pragma warn .aus

void OIOofd::storeObject(const Object& obj)
{
	int objectNum;
 	if (add(obj,objectNum)) {	// object has not been stored 
		unsigned /*short*/ classNum;        	// /*short*/ MFM
		if (addClass(obj.isA(),classNum)) {	// object of this class has not been previously stored 
			char recordType = storeOnClass;
			*this << recordType;
			unsigned char classNameLen = (unsigned char)strlen(obj.className());        //(uchar) MFM
			*this << classNameLen;
			put(obj.className(),classNameLen);
			*this << obj.isA()->signature();
		}
		else {			// object of this class already stored, just output class reference
			char recordType = storeOnClassRef;
			*this << recordType;
			*this << classNum;
		}
		obj.storer(*this);		// call storer for this object 
	}
	else {		// object already stored, just output object reference
       		char recordType = storeOnObjectRef; 
		*this << recordType;
		*this << objectNum;
	}
}

void OIOofd::writeErr()
{
	setError(NIHCL_STOREBINERR,DEFAULT,sys_errlist[errno]);
}

OIOifd& OIOifd::get(char* buf,unsigned nbyte)
{
	if (nbyte > 0) {
		int retval = read(fd,buf,nbyte);
		if (retval == -1) 
			setError(NIHCL_READBINERR,DEFAULT,sys_errlist[errno]);
		if (retval == 0) 
			setError(NIHCL_RDEOF,DEFAULT);
		if (retval < (int)nbyte)       	//(int) MFM
			setError(NIHCL_READBINUNDFL,DEFAULT,nbyte,retval);
	}
	return *this;
}

OIOifd& OIOifd::getCString(char* s, unsigned maxlen)
{
	unsigned n;
	*this >> n;
	if (n >= maxlen) {
	        get(s,maxlen);
		setError(NIHCL_STROV,DEFAULT,maxlen,s,maxlen);
	}
	get(s,n);
	s[n] = '\0';
	return *this;
}

OIOofd& OIOofd::putCString(const char* s)
{
	unsigned n = strlen(s);
	*this << n;
	return put(s,n);
}
