/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */

/*
Function:
	
Tables to keep track of multiple references to objects and classes.
Used by storeOn()/readFrom().
*/
#include "nihclstd.h"
#pragma hdrstop
 
#include "OIOTbl.h"
#include "AssocInt.h"

extern const int NIHCL_STMBRREF,NIHCL_STREFMBR;

StoreOnTbl::StoreOnTbl(unsigned size)
:
#ifdef MI
	storeVBaseTbl(256),
#endif
	d(size), c(Class::dictionary().size())
{
	level = objNum = classNum = 0;
}

StoreOnTbl::~StoreOnTbl()
{
	reset();
}

void StoreOnTbl::reset()
{
	DO(d,AssocInt,asc) delete asc; OD
	d.removeAll();
	DO(c,Class,cl) cl->number(0); OD
	c.removeAll();
#ifdef MI
	storeVBaseTbl.removeAll();
#endif
	objNum = classNum = 0;
}

bool StoreOnTbl::add(const Object& obj, int& num)
{
	if (&obj == Object::nil) {	// store nil as reference
		num = 0;		// to object #0
		return NO;
	}
	AssocInt* asc = (AssocInt*)d.assocAt(obj);
	if (asc == NULL) {	// object has not been stored
		d.add(*new AssocInt((Object&)obj, (num = ++objNum)));
		return YES;	// need to store object
	}
// return number of stored object
	num = (int)Integer::castdown(asc->value())->value();
	if (num == -1) setError(NIHCL_STREFMBR,DEFAULT,&obj,obj.className());
	return NO;		// don't need to store object -- use reference
}

bool StoreOnTbl::addClass(const Class* cp, unsigned /*short*/& num)  	// /*short*/ MFM
{
	if ((num = cp->number()) == 0) { 
		c.add(*(Class*)cp);
		((Class*)cp)->number(num = ++classNum);
		return YES;	// need to store class
	}
	return NO;	// don't need to store class -- use reference
}

void StoreOnTbl::addMember(const Object& obj)
{
	AssocInt* asc = (AssocInt*)d.assocAt(obj);
	if (asc == NULL) {			// object has not been stored 
		d.add(*new AssocInt((Object&)obj,-1));	// add member object to IdentDict
		return;
	}
// Error -- tried to store a member object that has already been stored
   	int objectNum = (int)Integer::castdown(asc->value())->value(); 
	setError(NIHCL_STMBRREF,DEFAULT,objectNum,&obj,obj.className());
}

#ifdef MI

bool StoreOnTbl::_storeVBase(const void* p)
{
	if (storeVBaseTbl.includes(*(Object*)p)) return NO;
	storeVBaseTbl.add(*(Object*)p);
	return YES;
}

#endif

OrderedCltn StoreOnTbl::classesStored()
{
	return c;
}

OrderedCltn StoreOnTbl::objectsStored()
{
	ArrayOb t(objNum+1);
	t[0] = Object::nil;
	DO(d,AssocInt,asc) {
		int i = (int)Integer::castdown(asc->value())->value();
		if (i != -1) t[i] = asc->key();
	} OD
	return t.asOrderedCltn();
}

OrderedCltn StoreOnTbl::membersStored()
{
	OrderedCltn t;
	DO(d,AssocInt,asc) {
		int i = (int)Integer::castdown(asc->value())->value();
		if (i == -1) t.add(*asc->key());
	} OD
	return t;
}

void StoreOnTbl::dumpOn(ostream& strm) const
{
	strm << "StoreOnTbl" << '[' << endl;
	strm << "  storeOn() level " << level << endl;
	strm << "  highest class number " << classNum << endl;
	strm << "  highest object number " << objNum << endl;
	strm << "  dump of stored class descriptor table:\n";
	c.dumpOn(strm);
	strm << "  dump of stored object table:\n";
	d.dumpOn(strm);
	strm << ']' << endl;
}

ReadFromTbl::ReadFromTbl(unsigned size)
	: obs(size), cls(Class::dictionary().size())
{
	level = addObject = 0;
	currentClass = NULL;
	obs.add(*Object::nil);		// nil is @0
}

void ReadFromTbl::reset()
{
	obs.removeAll();
	cls.removeAll();
	addObject = 0;
	obs.add(*Object::nil);		// nil is @0
}

void ReadFromTbl::add(Object& obj)
{
	if (addObject++ == 0) {
		unsigned int objectNum = obs.size();         	// unsigned MFM
		if (objectNum == obs.capacity()) obs.reSize(objectNum+1024);
		obs.add(obj);
#ifdef DEBUG_OBJIO
		cerr << ", object #" << objectNum << "\n";
#endif
	}
}

int ReadFromTbl::add(const Class* cl)
{
	int classNum = cls.size()+1;
	cls.add(*(Class*)cl);
	return classNum;
}

Object* ReadFromTbl::objectAt(int i)
{
	return obs[i];
}

const Class* ReadFromTbl::classAt(int i)
{
	return Class::castdown(cls[i-1]);
}

OrderedCltn ReadFromTbl::classesRead()
{
	return cls;
}

OrderedCltn ReadFromTbl::objectsRead()
{
	return obs;
}

const Class* ReadFromTbl::readFromClass(const Class* newClass)
{
	const Class* oldClass = currentClass;
	currentClass = newClass;
	return oldClass;
}

void ReadFromTbl::dumpOn(ostream& strm) const
{
	strm << "ReadFromTbl" << '[' << endl;
	strm << "  readFrom() level " << level << endl;
	strm << "  add object enable flag " << addObject << endl;
	strm << "  dump of read class descriptor table:\n";
	cls.dumpOn(strm);
	strm << "  dump of read objects table:\n";
	obs.dumpOn(strm);
	strm << ']' << endl;
}
