/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: OrderedCltn.c,v 3.15 92/07/26 14:33:22 */

#include "nihclstd.h"
#pragma hdrstop

#include <assert.h>

#include "OrderedC.h"
#include "nihclIO.h"

#define	THIS	OrderedCltn
#define	BASE	SeqCltn
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES ArrayOb::desc()
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(OrderedCltn,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

extern const int NIHCL_CLTNEMPTY,NIHCL_OBNOTFOUND;            

OrderedCltn::OrderedCltn(unsigned size) : contents(size)
{
	endIndex = 0;
}

OrderedCltn::OrderedCltn(const OrderedCltn& c) : contents(c.contents)
{
	endIndex = c.endIndex;
}

bool OrderedCltn::operator==(const OrderedCltn& a) const
{
	if (endIndex != a.endIndex) return NO;
	else {
		if (endIndex == 0) return YES; // both Cltns empty
		int i = endIndex;
		const Object* const* vv = &contents.elem(0);
		const Object* const* av = &a.at(0);
		while (i--) { 
			assert(vv);   
			assert(*vv); 
			assert(av);
			assert(*av);
			if (!((*vv++)->isEqual(**av++))) 
				return NO;
		}	
	}
	return YES;
}

OrderedCltn OrderedCltn::operator&(const SeqCltn& cltn) const
{
	OrderedCltn c(size()+cltn.size());
	addContentsTo(c);
	cltn.addContentsTo(c);
	return c;
}

void OrderedCltn::operator&=(const SeqCltn& cltn)
{
	cltn.addContentsTo(*this);
}

Object* OrderedCltn::addAtIndex(int i, Object& ob)                      
{
	if (endIndex == (int)capacity()) {                       // (int) MFM
		contents.reSize(capacity()+EXPANSION_INCREMENT);      
	}		     
	for (int j=endIndex; j>i; j--) contents[j] = contents[j-1];         
	contents[i] = &ob;
	endIndex++;
	return &ob;
}

Object* OrderedCltn::removeAtIndex(int i)
{                                                                                
	Object* obrem = contents[i];
	for (int j=i+1; j<endIndex; j++) contents[j-1] = contents[j];
	contents[--endIndex] = nil;
	return obrem;
}

Object* OrderedCltn::add(Object& ob)
{
	addAtIndex(endIndex,ob);
	return &ob;
}

Object* OrderedCltn::addAfter(const Object& ob, Object& newob)
{
	int i = indexOf(ob);
	if (i < 0)
		errNotFound("addAfter",ob);
	return addAtIndex(i+1,newob);
}

Object* OrderedCltn::addAllLast(const OrderedCltn& cltn)
{
	if (endIndex+cltn.size() >= capacity())
		contents.reSize(endIndex+cltn.size()+EXPANSION_INCREMENT);
	for (int i=0; i<(int)cltn.size(); i++)         	               // (int) MFM
		contents[endIndex++] = (Object*)cltn.contents[i];
	return (Object*) &cltn;
}

Object* OrderedCltn::addBefore(const Object& ob, Object& newob)
{
	int i = indexOf(ob);
	if (i < 0)
		errNotFound("addBefore",ob);
	return addAtIndex(i,newob);
}

Collection& OrderedCltn::addContentsTo(Collection& cltn) const
{
	for (int i=0; i<(int)size(); i++) cltn.add(*(Object*)contents[i]);     
	return cltn;
}

Object* OrderedCltn::addLast(Object& ob) { return add(ob); }

Object* OrderedCltn::after(const Object& ob) const
{
	int i=indexOf(ob);
	if (i<0)
		errNotFound("after",ob);
	if (++i == endIndex) return nil;
	return (Object*)contents[i];
}
            
Object*& OrderedCltn::at(int i)							{ return (*this)[i]; }
const Object *const& OrderedCltn::at(int i) const	{ return (*this)[i]; }

void OrderedCltn::atAllPut(Object& ob)
{
	for (int i=0; i<endIndex; i++) contents[i] = &ob;
}

Object* OrderedCltn::before(const Object& ob) const
{
	int i = indexOf(ob);
	if (i < 0)
		errNotFound("before",ob);
	if (--i < 0)
		return nil;
	return (Object*)contents[i];
}

unsigned OrderedCltn::capacity() const	{ return contents.capacity(); }

void OrderedCltn::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	int i = endIndex;   		
	Object** vv = &contents.elem(0);
	while (i--) {
		*vv = (*vv)->deepCopy();
		vv++;
	}
}

Object* OrderedCltn::first() const
{
	if (endIndex==0) {
		errEmpty("first");
		/* not reached */
		return NULL;
   }
	else return (Object*)contents.elem(0);
}

unsigned long OrderedCltn::hash() const
{
	unsigned long h = endIndex;
	unsigned int i = endIndex;
	const Object* const* vv = &contents.elem(0);
	while (i--) h^=(*vv++)->hash();
	return h;
}

int OrderedCltn::indexOf(const Object& ob) const
{
	for (int i=0; i<endIndex; i++)
		if (contents[i]->isEqual(ob)) return i;
	return -1;
}

int OrderedCltn::indexOfSubCollection(const SeqCltn& cltn, int start) const
{
	unsigned int subsize = cltn.size();
	for ( int i=start; i<(int)(endIndex-subsize); i++) {          //(int) MFM
		for (unsigned int j=0; j<subsize; j++)
			if (!(contents[i+j]->isEqual(*cltn.at(j)))) goto next;
		return i;
next:;	}
	return -1;
}

bool OrderedCltn::isEmpty() const { return endIndex==0; }
	
Object* OrderedCltn::last() const
{
	if (endIndex==0) {
		errEmpty("last");
		/* not reached */
		return NULL;
   }
	else return (Object*)contents.elem(endIndex-1);
}

unsigned OrderedCltn::occurrencesOf(const Object& ob) const
{
	unsigned n=0;
	for (int i=0; i<endIndex; i++)
		if (contents[i]->isEqual(ob)) n++;
	return n;
}

Object* OrderedCltn::remove(const Object& ob)
{
	for (int i=0; i<endIndex; i++) {
		if (contents[i]->isEqual(ob)) {
			return removeAtIndex(i);
		}
	}
	return nil;
}

void OrderedCltn::removeAll()
{
	for (int i=0; i<endIndex; i++) contents[i] = nil;
	endIndex = 0;
}

Object* OrderedCltn::removeId(const Object& ob)
{
	for (int i=0; i<endIndex; i++) {
		if (contents[i] == &ob) return removeAtIndex(i);
	}
	return nil;
}

Object* OrderedCltn::removeLast()
{
	if (endIndex==0) {
		errEmpty("removeLast");
		/* not reached */
		return NULL;
	}
	else return removeAtIndex(endIndex-1);
}

void OrderedCltn::reSize(unsigned newSize)
{
	if (newSize > size()) contents.reSize(newSize);
}

void OrderedCltn::replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt)
{
	int j=startAt;
	for (int i=start; i<=stop; i++,j++)
		contents[i] = ((SeqCltn&)replacement).at(j);
}

static int compare_ob(const void* a, const void* b)
{
	return (*(const Object**)a)->compare(**(const Object**)b);
}

unsigned OrderedCltn::size() const		{ return endIndex; }

void OrderedCltn::sort()
{
     qsort(&contents.elem(0),size(),sizeof(Object*),compare_ob);
}

void OrderedCltn::errEmpty(const char* fn) const
{
	setError(NIHCL_CLTNEMPTY,DEFAULT,this,className(),fn);
}

void OrderedCltn::errNotFound(const char* fn, const Object& ob) const
{
	setError(NIHCL_OBNOTFOUND,DEFAULT,this,className(),fn,ob.className(),&ob);
}

OrderedCltn Collection::asOrderedCltn() const
{  
#ifdef MAXASARG	
	unsigned t_size = MAX(size(),DEFAULT_CAPACITY);
	OrderedCltn cltn(t_size); 
#else
   OrderedCltn cltn(MAX(size(),DEFAULT_CAPACITY)); 
#endif	
	addContentsTo(cltn);
	return cltn;
}

static unsigned orderedcltn_capacity;

OrderedCltn::OrderedCltn(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm),
	contents((strm >> orderedcltn_capacity, orderedcltn_capacity))
{
	endIndex = 0;
	unsigned n;
	strm >> n;		// read collection capacity 
	while (n--) add(*Object::readFrom(strm));
}

OrderedCltn::OrderedCltn(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd),
	contents((fd >> orderedcltn_capacity, orderedcltn_capacity))
{
	endIndex = 0;
	unsigned n;
	fd >> n;
	while (n--) add(*Object::readFrom(fd));
}

void OrderedCltn::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	_storer(fd);
}

void OrderedCltn::storer(OIOout& strm) const
{
	BASE::storer(strm);
	_storer(strm);
}
