/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: Random.c,v 3.14 92/12/19 15:53:23  */
/*
Function:
	
A psuedo-random number generator.  The function next() returns random
numbers uniformly distributed over the interval (0.0,1.0).

Reference:

Pierre L'ecuyer, "Efficient and Portable Combined Random Number
Generators", Commun. ACM 31, 6 (June 1988), 742-749.
*/
#include "nihclstd.h"
#pragma hdrstop
 
#include <time.h>
 
#include "Random.h"
#include "nihclIO.h"

#define	THIS	Random
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(Random,2,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

const long s1max = 2147483562L;
const long s2max = 2147483398L;

void Random::checkSeeds()
{
#if 0
	if (sizeof(long) != 4) {
		cerr << "\nRandom only works on 32-bit machines\n";
		exit(1);
	}
#endif
	if (s1 < 1 || s1 > s1max) s1 = (ABS(s1) % s1max) + 1;
	if (s2 < 1 || s2 > s2max) s2 = (ABS(s2) % s2max) + 1;
}

Random::Random()
{
	time((time_t*)&s1);
	s2 = (long)this;
	checkSeeds();
}

Random::Random(long seed1, long seed2)
{
	s1 = seed1;  s2 = seed2;
	checkSeeds();
}

float Random::next()
{
	long Z,k;

	k = s1/53668L;
	s1 = 40014L * (s1 - k * 53668L) - k * 12211L;
	if (s1 < 0) s1 += s1max + 1;

	k = s2/52774L;
	s2 = 40692L * (s2 - k * 52774L) - k * 3791L;
	if (s2 < 0) s2 += s2max + 1;

	Z = s1 - s2;
	if (Z < 1) Z += s1max;

	return (float)(Z * 4.656613E-10);		// (float) MFM
}

void Random::deepenShallowCopy()	{}

unsigned long Random::hash() const	{ return (unsigned long)this; }

bool Random::isEqual(const Object& ob) const   { return isSame(ob); }

void Random::printOn(ostream& strm) const
{
	strm << s1 << ' ' << s2;
}

Random::Random(OIOin& strm)
	: BASE(strm)
{
	strm >> s1 >> s2;
}

void Random::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << s1 << s2;
}

Random::Random(OIOifd& fd)
	: BASE(fd)
{
	fd >> s1 >> s2;
}

void Random::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << s1 << s2;
}

int Random::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}
