/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: SeqCltn.c,v 3.13 92/07/26 14:33:36 */

/*
Function:
	
SeqCltn is an abstract class representing collections whose elements are
ordered and are externally named by integer indices.
*/

#include "nihclstd.h"
#pragma hdrstop

#include "SeqCltn.h"
#include "nihclIO.h"
                     
#include <assert.h>
                     
#define	THIS	SeqCltn
#define	BASE	Collection
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_ABSTRACT_CLASS(SeqCltn,0,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

extern const int NIHCL_RDABSTCLASS,NIHCL_INDEXRANGE;
                       
#if defined(LINKPUREVIRT)	
unsigned SeqCltn::size() const
{
	assert(0);
	abort();
	return 0;
}

unsigned SeqCltn::capacity() const
{
	assert(0);                       
	abort();
	return 0;
}	
#endif
	
SeqCltn::SeqCltn() {}

SeqCltn::SeqCltn(OIOifd& fd) : BASE(fd) {}

SeqCltn::SeqCltn(OIOin& strm) : BASE(strm) {}

int SeqCltn::compare(const Object& arg) const
// Compare two sequenced collections.  If *this > arg return >0,
// *this == arg return 0, and if *this < arg return <0.
{
	assertArgClass(arg,*SeqCltn::desc(),"compare");
	Iterator i(*this);
	Iterator j(castdown(arg));
	Object*	p;	// pointer to next object in this SeqCltn
	Object*	q;	// pointer to next object in arg SeqCltn

	while ((q = j++, p = i++)) {
// previous elements compared equal; longer SeqCltn is therefore larger
		if (q == 0) return 1;
// compare() != 0 at any element determines ordering
		int val;
		if ((val = p->compare(*q)) != 0) return val;
	}
// all elements in this SeqCltn compare() equal to arg SeqCltn
	if (q == 0) return 0;	// size() == arg.size()
	return -1;
}

bool SeqCltn::sameContentsInOrderAs(const SeqCltn& c) const
{
    if ( size()==0&&c.size()==0 ) return YES;
    if ( size()!=c.size() ) return NO;
    for ( unsigned int i=0; i< size(); i++ )   			// unsigned MFM
        if ( !at(i)->isSame(*c.at(i)) ) return NO;
    return YES;
}

Object* SeqCltn::first() const { return (Object*)at(0); }
	
unsigned long SeqCltn::hash() const
{
	unsigned long h = size();
	DO(*this,Object,p) h ^= p->hash(); OD
	return h;
}

int SeqCltn::indexOf(const Object& ob) const
{
	int i = 0;
	DO(*this,Object,p)
		if (p->isEqual(ob)) return i;
		i++;
	OD
	return -1;
}

bool SeqCltn::isEqual(const Object& ob) const
{
	if (!ob.isKindOf(*SeqCltn::desc())) return NO;
	if (size() != ob.size()) return NO;
	Iterator i(*this);
	Iterator j(castdown(ob));
	Object* p;
	while ((p = i++) != NULL)			// MFM quiet compiler
		if (!p->isEqual(*(j++))) return NO;
	return YES;
}

const Class* SeqCltn::species() const	{ return &classDesc; }

Object* SeqCltn::last() const { return (Object*)at(size()-1); }

unsigned SeqCltn::occurrencesOf(const Object& ob) const
{
	unsigned n = 0;
	DO(*this,Object,p) if (p->isEqual(ob)) n++; OD
	return n;
}
	
Object* SeqCltn::doNext(Iterator& pos) const
{
	if (pos.index < size()) return (Object*)at(pos.index++);
	return NULL;
}

void SeqCltn::indexRangeErr() const
{
	setError(NIHCL_INDEXRANGE,DEFAULT,this,className());
}
