/* Test classes Catch, ExceptionAction, and ExceptionTrap


*/
/* MSDOS revisions - Michael Murphy 1993
 * 8.3 filenames
 * ulong hash()
 * main() return value
 * output to cout not cerr
 */

#include "nihclstd.h"
#pragma hdrstop 
 
#include <Stack.h>
#include <Exceptio.h>
#include <nihclIO.h>
#include <niherrs.h>

void xtrap(unsigned& err, int& sev)
{
	cout << "xtrap(" << err << ',' << sev << ") called\n";
}

class MyClass : public VIRTUAL Object {
	DECLARE_MEMBERS(MyClass);
	int n;
	Catch catcherr;
public:
	MyClass(int i) : catcherr(this) {
		n = i;
		cout << "MyClass(" << n << ") constructed\n";
	}
	virtual void deepenShallowCopy();
	virtual void destroyer() {
		cout << "MyClass(" << n << ") destroyed\n";
	}
	virtual unsigned long hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
private:			// shouldNotImplement()
	virtual int compare(const Object&) const;
};

#define	THIS	MyClass
#define	BASE	Object
#define	BASE_CLASSES BASE::desc()
#define	MEMBER_CLASSES
#define	VIRTUAL_BASE_CLASSES

DEFINE_CLASS(MyClass,1,"",NULL)

MyClass::MyClass(OIOifd& fd) : Object(fd) { fd >> n; }
 
MyClass::MyClass(OIOin& strm) : Object(strm) { strm >> n; }

void MyClass::deepenShallowCopy() {}

unsigned long MyClass::hash() const	{ return (unsigned long)this; }

bool MyClass::isEqual(const Object& a) const { return isSame(a); }

void MyClass::printOn(ostream& /*strm*/) const {}

int MyClass::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}

main()
{
	cout << "Test classes Catch, ExceptionAction, and ExceptionTrap\n";
	Stack s;
	MyClass* p = new MyClass(-1);
	MyClass* q = new MyClass(-2);
	{
		MyClass a(1);
		MyClass b(2);
		RaiseException x(NIHCL__CLTNEMPTY);
		BEGINX
			MyClass c(3);
			MyClass d(4);
			{
				MyClass e(5);
				MyClass f(6);
				delete p;
				s.pop();
			}
		EXCEPTION
			case NIHCL__CLTNEMPTY: {
				MyClass g(7);
				MyClass h(8);
				cout << "CLTNEMPTY error handled\n";
			}
		ENDX
	}
	delete q;
	{
		ExceptionTrap x(xtrap);
		s.pop();
	}
	return 0;
}
