/* Test class IdentDict
 
*/
/* MSDOS revisions - Michael Murphy 1993
 * 8.3 filenames
 * main() return value
 * __MSDOS__ includes
 */

#include "nihclstd.h"
#pragma hdrstop 
 

#include <Assoc.h>
#include <Bitset.h>
#include <IdentDic.h>
#include <OrderedC.h>
#include <Point.h>
#include <Rectangl.h>
#include <Set.h>
#include <SortedCl.h>
#include <Stack.h>
#include <NIHStrin.h>
#include <OIOnih.h>
#include <fstream.h>

Object* testStore()
{
	Bitset& bitset = *new Bitset(Bitset::bit(4)|Bitset::bit(6));
	IdentDict& iddict = *new IdentDict;
	OrderedCltn& orderedcltn = *new OrderedCltn;
	Point& point = *new Point(1,2);
	Rectangle& rect = *new Rectangle(0,1,2,3);
	Set& set = *new Set;
	SortedCltn& sortedcltn = *new SortedCltn;
	Stack& stack = *new Stack;
	String& str = *new String("Hello, world!");
	orderedcltn.add(point); orderedcltn.add(rect); orderedcltn.add(str);
	stack.push(bitset); stack.push(orderedcltn);
	sortedcltn.add(*new String("Huey"));
	sortedcltn.add(*new String("Dewey"));
	sortedcltn.add(*new String("Louie"));
	iddict.add(*new Assoc(orderedcltn,point));
	iddict.add(*new Assoc(bitset,rect));
	iddict.add(*new Assoc(sortedcltn,stack));
	set.add(orderedcltn);
	set.add(stack);
	set.add(sortedcltn);
	set.add(iddict);
	OrderedCltn& monster = *new OrderedCltn;
	monster.add(set);
	monster.add(*set.deepCopy());
	return &monster;
}

#include <fcntl.h>
#ifdef __MS_DOS__
#include <stdlib.h>
#elif defined(__DECCXX)
#include <stdlib.h>
#else
#include <osfcn.h>
#endif

main()
{
	cout << "Test storeOn" << endl;
	char* fileName = "iddicta";
	Object* a = testStore();
	ofstream out(fileName);
	{ // storeOn a to stream attached to fileName
			  OIOnihout nihout(out); 
			  a->storeOn(nihout); 
		  }
#ifdef __MS_DOS__
	out.close();
#endif
	cout << "Test readFrom" << endl;
	Object* b;
		  { // readFrom b from stream attached to fileName
		ifstream in(fileName);
			  OIOnihin nihin(in);
		b = Object::readFrom(nihin);
	}
	cout << "*** object stored:" << endl << *a << endl;
	cout << "*** object read:" << endl << *b << endl;
	fileName = "iddictb";
		  { // storeOn b to stream attached to fileName
		out.open(fileName);
			  OIOnihout nihout(out);
		b->storeOn(nihout);
	}
	out.close();
	return 0;
}
