/* Test class Iterator


*/

/* MSDOS revisions - Michael Murphy 1993
 * 8.3 filenames
 * __MSDOS__ includes
 * .io file extension not .obj
 * main() return value
 */

#include "nihclstd.h"
#pragma hdrstop 
 
#include <Iterator.h>
#include <LinkedLi.h>
#include <OrderedC.h>
#include <Set.h>
#include <Heap.h>
#include <Point.h>
#include <LinkOb.h>
#include <OIOnih.h>
#include <fstream.h>
#include <fcntl.h>
#ifdef __MS_DOS__
#include <stdlib.h>
#elif defined(__DECCXX)
#include <stdlib.h>
#else
#include <osfcn.h>
#endif

const char* fileName = "iterator.io";

main()
{
	cout << "\nTest class Iterator" << endl;
	OrderedCltn c,x;
	{ for (int j=0; j<6; j++) c.add(*new Point(j,j)); }
	c.dumpOn(cout);  cout.flush();
	Set s;
	s = c.asSet();
	s.dumpOn(cout);  cout.flush();
	LinkedList l;
	Iterator i(s);
	Object* p;
	while ((p = i++) != NULL) l.add(*new LinkOb(*p));
	l.dumpOn(cout);  cout.flush();
	Heap h;
	h = c.asHeap();
	h.dumpOn(cout); cout.flush();
	x.add(c); x.add(l); x.add(h);

	 DO(x,Collection,cp) {
	cout << "\nTest Iterator(" << cp->className() << ").storeOn()" << endl;
	Iterator ii(*cp);
	ii.dumpOn(cout);  cout.flush();
	{ for (int j=0; j<3; j++) cout << *ii++; }
	cout << endl;
	ii.dumpOn(cout);  cout.flush();
	{ // storeOn ii to stream attached to fileName
		 ofstream out(fileName);
		 OIOnihout nihout(out);
		 ii.storeOn(nihout);
	}
	cout << "\nTest Iterator(" << cp->className() << ") readFrom()" << endl;
	Iterator* ip;
	{ // readFrom ip from stream attached to fileName
		 ifstream in(fileName);
		 OIOnihin nihin(in);
		 ip = Iterator::readFrom(nihin);
	}
	ip->dumpOn(cout);  cout.flush();
	while ((p = (*ip)++) != NULL) cout << *p;
	Collection* tcp=(Collection*)ip->collection();
	delete ip;
	delete tcp;

	cout << "\nTest Iterator(" << cp->className() << ").deepCopy()" << endl;
	ip = Iterator::castdown(ii.deepCopy());
	ip->dumpOn(cout);  cout.flush();
	while ((p = (*ip)++) != NULL) cout << *p;
	cout << "\nTest Iterator(" << cp->className() << ").reset()" << endl;
	ip->reset();
	ip->dumpOn(cout);  cout.flush();
	while ((p = (*ip)++) != NULL) cout << *p;
	cout << endl;
	tcp=(Collection*)ip->collection();
	delete ip;
	delete tcp;
	 } OD;
	return 0;
}
