/* Test class Date           
*/
/* MSDOS revisions - Michael Murphy 1993
 * 8.3 filenames
 * __MSDOS__ includes
 * main() return value
 * 
 */

#include "nihclstd.h"
#pragma hdrstop 
 
#ifdef __MS_DOS__
#include <stdlib.h>
#elif defined(__DECCXX)
#include <stdlib.h>
#else
#include <osfcn.h>
#endif
#include <Date.h>
#include <SortedCl.h>

main()
{
	cout << "\nTest class Date" << endl;
	char junk[100];
	Date today;
	Date tomorrow(today+1);
	Date yesterday(today-1);
	Date reference(25,"Dec",1985);
	Date ref_copy = reference;
	SortedCltn datelist;
	Date::dayTy d;
	
//      This portion is to check those functions of Date which only need
//      to be tested once.
	
	cerr << "Today is " << Date::nameOfDay(today.weekDay()) << ", " << today << endl;
	cerr << "Tomorrow is " << Date::nameOfDay(tomorrow.weekDay()) << ", " << tomorrow << endl;
	cerr << "Yesterday was " << Date::nameOfDay(yesterday.weekDay()) << ", " << yesterday << endl;

	cout << "Date(5) = "  << Date(5L) << endl;
	cout << "Date(-3) = " << Date(-3L) << endl;
	cout << "Date(367, 1984) = " << Date(367,1984) << endl;
	cout << "Date(-1, 1984) = " << Date(-1,1984) << endl;
	cout << "nameOfMonth(6) = " << Date::nameOfMonth(6) << endl;

	cout << "Enter string for dayOfWeek: ";
	cin  >> junk;
	if (cin.eof()) { cout << endl; exit(1); } 
	cout << "dayOfWeek(" << junk << ") = " << Date::dayOfWeek(junk) << endl;
	cout << "Enter string for numberOfMonth: ";
	cin  >> junk;
	if (cin.eof()) { cout << endl; exit(1); } 
	cout << "numberOfMonth(" << junk << ") = " << Date::numberOfMonth(junk) << endl;
	cout << "Enter number for nameOfDay: ";
	cin  >> d;
	if (cin.eof()) { cout << endl; exit(1); } 
	cout << "nameOfDay(" << d << ") = " << Date::nameOfDay(d) << endl;

	cout << "Reference date is " << ref_copy << endl;
	cout << "Enter date for scanFrom: ";
	ref_copy.scanFrom(cin);
	cout << "Replaced ref_copy by " << ref_copy << endl;

// Now do the repetitive stuff.

	while (YES) {
		cout << "Enter date: "; Date& date = *new Date(cin); cout << endl;
		if (cin.eof()) break;
		if (cin.fail()) { cout << "Bad date" << endl;  cin.clear();  cin.get(junk,sizeof junk);  continue; }
		cout << Date::nameOfDay(date.weekDay()) << ", " << date << endl;
		cout << reference << " - " << date << " = " << (reference-date) << endl;
		cout << date << " between(1-Jan-85, 31-Dec-85): " << (date.between(Date(1,"Jan",85), Date(31,"Dec",85))) << endl;
		cout << date << " max(" << reference << ") = " << date.max(reference) << endl;
		cout << date << " min(" << reference << ") = " << date.min(reference) << endl;
		cout << "The date of the previous Sunday is " << date.previous("Sun") << endl;
		cout << "The date of the previous Thursday is " << date.previous("Thursday") << endl;
		cout << "date.compare(reference) = " << date.compare(reference) << endl;
		cout << "date.day() = "     << date.day()          << endl;
		cout << "date.dayOfMonth() = "       << date.dayOfMonth()       << endl;
		cout << "daysInYear(date.year()) = " << Date::daysInYear(date.year()) << endl;
		cout << "date.firstDayOfMonth() = "  << date.firstDayOfMonth()  << endl;
		cout << "date.hash() = "        << date.hash()     << endl;
		cout << "date.isEqual(reference) = " << date.isEqual(reference)   << endl;
		cout << "this + 50 = "          << (date + 50)    << endl;
		cout << "50 + this = "          << (50 + date)    << endl;
		cout << "this - 60  = "         << (date - 60)    << endl;
		cout << "this < reference = "      << (date < reference) << endl;
		cout << "this > reference = "      << (date > reference) << endl;
		cout << "this <= reference = "        << (date <= reference)   << endl;
		cout << "this >= reference = "        << (date >= reference)   << endl;
		cout << "this == reference = "        << (date == reference)   << endl;
		cout << "this != reference = "        << (date != reference)   << endl;
		Date date1=date;
		date1 += 50;
		cout << "this += 50 = "         << date1        << endl;
		Date date2=date;
		date2 -= 60;
		cout << "this -=60 = "          << date2        << endl;
		datelist.add(date);
		cout << datelist << endl;

	} // while(YES)

	cout << endl;
	return 0;
}
