/* Test Object I/O


*/

/* MSDOS revisions - Michael Murphy 1993
 * __MSDOS__ includes
 * 8.3 filenames
 * exclude types not implemented
 * .io file extensions instead of .obj
 * MSDOS filesystem commands
 * local getopt needed
 */

#include "nihclstd.h"
#pragma hdrstop 
 
#include <fstream.h>
#ifdef __MS_DOS__
#include <stdlib.h>
#elif defined(__DECCXX)
#include <stdlib.h>
#else
#include <osfcn.h>
#endif
#include <nihclcon.h>
#include <ArrayOb.h>
//#include <nihcl/Arraychar.h>
#include <Assoc.h>
#include <Bag.h>
#include <Bitset.h>
#include <Date.h>
#include <Dictiona.h>
//#include <nihcl/FDSet.h>
#include <NIHFloat.h>
#include <Fraction.h>
#include <Heap.h>
#include <LinkedLi.h>
#include <LinkOb.h>
#include <OrderedC.h>
#include <Point.h>
#include <Range.h>
#include <Rectangl.h>
#include <Set.h>
#include <SortedCl.h>
#include <Stack.h>
#include <NIHStrin.h>
#include <NIHTime.h>
#include <OIOnih.h>
#include <OIOfd.h>


#ifdef __MS_DOS__
// approx ATT version - MFM
int   optind = 1;
char  *optarg;

int getopt(int argc, char** argv, char* opts)
{
	static int sp = 1;
	register int c;
	register char *cp;

	if(sp == 1)
		if(optind >= argc ||
			argv[optind][0] != '-' || argv[optind][1] == '\0')
			return(EOF);
		else if(strcmp(argv[optind], "--") == NULL) {
			optind++;
			return(EOF);
		}
	c = argv[optind][sp];
	if(c == ':' || (cp=strchr(opts, c)) == NULL) {
		cerr << argv[0] << ": illegal option -- " << (char)c << endl;
		if(argv[optind][++sp] == '\0') {
			optind++;
			sp = 1;
		}
		return('?');
	}
	if(*++cp == ':') {
		if(argv[optind][sp+1] != '\0')
			optarg = &argv[optind++][sp+1];
		else if(++optind >= argc) {
			cerr << argv[0] << ": option requires an argument -- " <<  (char)c << endl;
			sp = 1;
			return('?');
		} else
			optarg = argv[optind++];
		sp = 1;
	} else {
		if(argv[optind][++sp] == '\0') {
			sp = 1;
			optind++;
		}
		optarg = NULL;
	}
	return(c);
}
#endif /* __MS_DOS__ */


Object* testStore()
{
	ArrayOb& arrayob = *new ArrayOb(4);
// Arraychar& arraychar = *new Arraychar(26);
	Bag& bag = *new Bag(100);
	Bitset& bitset = *new Bitset(4,6);
	Date& date = *new Date(11,"Nov",48);
	Dictionary& dict = *new Dictionary(100);
// FDSet& fdset = *new FDSet(); fdset[0] = fdset[1] = fdset[19] = 1;
	Float& flt = *new Float(3.1415);
	Fraction& fract = *new Fraction(22,7);
	Heap& heap = *new Heap;
	LinkedList& linkedlist = *new LinkedList;
	OrderedCltn& orderedcltn = *new OrderedCltn;
	Point& point = *new Point(1,2);
	Range& range = *new Range(-1,1);
	Rectangle& rect = *new Rectangle(0,1,2,3);
	Set& set = *new Set(100);
	SortedCltn& sortedcltn = *new SortedCltn;
	Stack& stack = *new Stack;
	String& str = *new String("123456789a123456789b123456789c123456789d123456789e123456789f123456789g12345678\012h Hello, world!\t{\033\"\\}");
	Time& time = *new Time(date,1,2,3);
	
	arrayob[0] = &bitset; arrayob[1] = &point; arrayob[2] = &str;
// for (int i = 0; i < 26; i++) arraychar[i] = "abcdefghijklmnopqrstuvwxyz"[i];
	orderedcltn.add(point); orderedcltn.add(rect); orderedcltn.add(str);
	orderedcltn.add(flt); orderedcltn.add(fract); orderedcltn.add(range);
	orderedcltn.add(date); orderedcltn.add(time); /*orderedcltn.add(fdset);*/
	stack.push(bitset); stack.push(orderedcltn);
	bag.addWithOccurrences(point,1);
	bag.addWithOccurrences(rect,2);
	bag.addWithOccurrences(str,3);
	bag.add(orderedcltn);
	sortedcltn.add(*new String("Huey"));
	sortedcltn.add(*new String("Dewey"));
	sortedcltn.add(*new String("Louie"));
	heap.add(*new String("Dasher"));
	heap.add(*new String("Dancer"));
	heap.add(*new String("Prancer"));
	heap.add(*new String("Vixen"));
	heap.add(*new String("Comet"));
	heap.add(*new String("Cupid"));
	heap.add(*new String("Donder"));
	heap.add(*new String("Blitzen"));
	dict.add(*new Assoc(orderedcltn,point));
	dict.add(*new Assoc(bag,rect));
	dict.add(*new Assoc(sortedcltn,stack));
	linkedlist.add(*new LinkOb(point));
	linkedlist.add(*new LinkOb(rect));
	linkedlist.add(*new LinkOb(bitset));
	linkedlist.add(*new LinkOb(str));
	
	set.add(arrayob);
// set.add(arraychar);
	set.add(bag);
	set.add(dict);
	set.add(heap);
	set.add(linkedlist);
	set.add(orderedcltn);
	set.add(sortedcltn);
	set.add(stack);

	OrderedCltn& monster = *new OrderedCltn;
	monster.add(set); monster.add(*set.deepCopy());
	return &monster;
}

#include <fcntl.h>

#ifdef __MS_DOS__
#include <sys\stat.h>
#include <io.h>
#endif

#ifdef __DECCXX
extern "C" {
	  int getopt(int argc, char** argv, char* optstring);
}
#endif

main(int argc, char** argv)
{
	extern int optind;      // used by getopt()
	extern char* optarg;    // used by getopt()
	char* filea = "oio.io";
	char* fileb;
	bool binaryIO = NO;  // test binary storeOn/readFrom flag
	bool dumpOpt = NO;   // dump read object on cout
	bool filebOpt = NO;  // file to store object read specified

// parse command options   

	int c;
	// ? is legal value too
	while ((c = getopt (argc, argv, "bd?")) != EOF)
		switch   (c) {
			case 'b': binaryIO = YES; break;
			case 'd': dumpOpt = YES; break;
			case '?':
				cerr << "usage: [ -bd ] [ filea [ fileb ] ]\n";
				/* MFM
					-b binary i/o
					-d dump
					filea = output to then read from (default oio.io)
					fileb = write to after reading
				*/
				exit(2);
		}
	if (optind < argc) filea = argv[optind++];
	if (optind < argc) {
		fileb = argv[optind++];
		filebOpt = YES;
	}
				
	Object* a = testStore();
	Object* b;
	OrderedCltn classesOut, objectsOut;
	OrderedCltn classesIn, objectsIn;
	
	if (binaryIO) {
#ifdef __MS_DOS__
		_fmode = O_BINARY;
#endif
		cout << "Test storeOn(OIOofd&)" << endl;
		{ // storeOn a to stream attatched to filea

			 int fd = creat(filea,/*0664*/S_IREAD|S_IWRITE);
			 OIOofd ofd(fd);
			 a->storeOn(ofd);
			 close(fd);  // MFM
			 classesOut = ofd.classesStored();
			 objectsOut = ofd.objectsStored();
		}
		cout << "Test readFrom(OIOifd&)" << endl;
		{ // readFrom b from stream attached to filea
			 int fd = open(filea,O_RDONLY);
			 OIOifd ifd(fd);
			 b = Object::readFrom(ifd);
			 close(fd);  // MFM
			 classesIn = ifd.classesRead();
			 objectsIn = ifd.objectsRead();
		}
#ifdef __MS_DOS__
		_fmode = O_TEXT;
#endif
	}
	else {
		cout << "Test storeOn(OIOout&)" << endl;
		{ // storeOn a to stream attached to filea
			 ofstream out(filea, ios::in|ios::out); // ios:: MFM
			 OIOnihout ostrm(out);
			 a->storeOn(ostrm);
			 out.close(); // MFM
			 classesOut = ostrm.classesStored();
			 objectsOut = ostrm.objectsStored();
		}
		cout << "Test readFrom(OIOin&)" << endl;
		{ // readFrom b from stream attached to filea
			 ifstream in(filea);
			 OIOnihin istrm(in);
			 b = Object::readFrom(istrm);
          in.close(); // MFM
			 classesIn = istrm.classesRead();
			 objectsIn = istrm.objectsRead();
		}
	}

	
// check classes stored against classes written

	if (classesIn == classesOut) {
		cout << "Classes OK, " << classesIn.size() << " classes stored and read" << endl;
	}
	else {
		cout << "Classes read not equal classes stored" << endl;
		cout << "Classes stored:" << endl;
		cout << classesOut << endl;
		cout << "Classes read:" << endl;
		cout << classesIn << endl;
	}

// check objects stored against objects written

	if (objectsIn.size() == objectsOut.size()) {
		for (int i=0; i < objectsIn.size(); i++) {
			if (objectsIn[i]->isA() != objectsOut[i]->isA()) {
				cout << "Object #" << i << " class mismatch, stored "
					<< *objectsOut[i]->isA() << ", got "
					<< *objectsIn[i]->isA() << endl;
				exit(1);
			}
		}
		cout << "Objects OK, " << objectsIn.size() << " objects stored and read" << endl;
	}
	else {
		cout << "Object I/O error -- " << objectsOut.size() << " objects stored, "
			<< objectsIn.size() << " objects read" << endl;
	}

// compare object stored with object read 
	
	if (a->isEqual(*b)) {
		cout << "SUCCESS! -- stored object equals object read" << endl;
		if (dumpOpt) {
			b->dumpOn(cout);
			cout << endl;
		}
	}
	else {
		cout << "FAILURE! -- stored object does not equal object read" << endl;
		cout << "*** object stored:" << endl;  a->dumpOn(cout);  cout << endl;
		cout << "*** object read:" << endl;  b->dumpOn(cout);  cout << endl;
		exit(1);
	}
	
// store object read 

	if (filebOpt) {
		if (binaryIO) {
#ifdef __MS_DOS__
			_fmode = O_BINARY;
#endif
			int fd =creat(fileb,/*0664*/S_IWRITE);
			OIOofd ofd(fd);
			b->storeOn(ofd);
			close(fd);
#ifdef __MS_DOS__
			_fmode = O_BINARY;
#endif
		}
		else {
			ofstream out(fileb);
			OIOnihout nihout(out);
			b->storeOn(nihout);
			out.close(); // MFM
		}
	}
	return 0;
}

