/* Test class OrderedCltn

*/
/* MSDOS revisions - Michael Murphy 1993
 * 8.3 filenames
 * main() return value
 */

#include "nihclstd.h"
#pragma hdrstop 
 
#include <Point.h>
#include <OrderedC.h>
#include <Set.h>

Point p;
#define POINT(X,Y)  *(p.x(X),p.y(Y),&p)

main()
{
	cout << "\nTest class OrderedCltn" << endl;
	Point A(1,1);
	Point B(1,2);
	Point C(1,3);
	Point D(1,3);
	OrderedCltn b(16);
	OrderedCltn c;
	b.add(A);
	b.add(B);
	b.add(C);
	b.add(D);
	cout << "b = " << b << endl;
	cout << "b.first(): " << *(b.first()) << endl;
	cout << "b.last(): " << *(b.last()) << endl;
	b.addAfter(POINT(1,2),*new Point(1,21));
	b.addBefore(POINT(1,2),*new Point(1,19));
	cout << "b = " << b << endl;
	cout << "b.after(Point(1,2)): " << *(b.after(POINT(1,2))) << endl;
	cout << "b.before(Point(1,2)): " << *(b.before(POINT(1,2))) << endl;
	c = b;
	b.reSize(30);
	cout << "b.includes(C): " << b.includes(C) << endl;
	cout << "c == b: " << (c==b) << endl;
	cout << "b.compare(c): " << b.compare(c) << endl;
	c.removeAll();
	cout << "c = " << c << endl;
	c = b;
	b.addAllLast(c);
	cout << "b = " << b << endl;
	cout << "b.compare(c): " << b.compare(c) << endl;
	cout << "c.compare(b): " << c.compare(b) << endl;
	b.remove(C);
	cout << "b.includes(C): " << b.includes(C) << endl;
	cout << "b = " << b << endl;
	cout << "c == b: " << (c==b) << endl;
	cout << "b.compare(c): " << b.compare(c) << endl;
	cout << "c&b:" << (c&b) << endl;
	cout << "b.indexOfSubCollection(c): " << b.indexOfSubCollection(c,1) << endl;
	cout << "c = " << c << endl;
	b.replaceFrom(1,3,c);
	cout << "b.replaceFrom(1,3,c): " << b << endl;
	b.sort();
	cout << "b.sort(): " << b << endl;
	cout << "b.asSet(): " << (b.asSet()) << endl;
	cout << "c.removeId(D)->isSame(D): " << c.removeId(D)->isSame(D) << endl;
	return 0;
}
