#if !defined (STDMACRO)           /* Prevents multiple declarations errors */
#define STDMACRO


/*
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Remy Gendron

   Description   : Standard macro definitions.
*/


/* Macros ---------------------------------------------------------------- */

#define FALSE 0                                          /* Boolean values */
#define TRUE  1
#define EV_MAYBE 2                               /* Not TRUE and not FALSE */

#define EV_VERSION 200                       /* EasyVision version's macro */

#define EV_DEF -1                                  /* Use default argument */
#define EV_NOHLPCTX -1                        /* No help context available */
#define EV_SAMEHLPCTX 0                     /* Keep last used help context */


                           /* Key codes returned by tinput::get and getkey */

#define II_NUL               0                          /* No input at all */
#define II_MOUSE             256      /* Input_info contains a mouse event */
#define II_BS                8                               /* Back space */
#define II_TAB               9                                      /* Tab */
#define II_CR                13                         /* Carriage return */
#define II_ESC               27                                  /* Escape */

#define II_S_TAB             271                              /* Shift-Tab */

#define II_A_Q               272                /* Alt-Q/W/E/R/T/Y/U/I/O/P */
#define II_A_W               273
#define II_A_E               274
#define II_A_R               275
#define II_A_T               276
#define II_A_Y               277
#define II_A_U               278
#define II_A_I               279
#define II_A_O               280
#define II_A_P               281

#define II_A_A               286                  /* Alt-A/S/D/F/G/H/J/K/L */
#define II_A_S               287
#define II_A_D               288
#define II_A_F               289
#define II_A_G               290
#define II_A_H               291
#define II_A_J               292
#define II_A_K               293
#define II_A_L               294

#define II_A_Z               300                      /* Alt-Z/X/C/V/B/N/M */
#define II_A_X               301
#define II_A_C               302
#define II_A_V               303
#define II_A_B               304
#define II_A_N               305
#define II_A_M               306

#define II_F1                315                                 /* F1-F10 */
#define II_F2                316
#define II_F3                317
#define II_F4                318
#define II_F5                319
#define II_F6                320
#define II_F7                321
#define II_F8                322
#define II_F9                323
#define II_F10               324
#define II_F11               389                                    /* F11 */
#define II_F12               390                                    /* F12 */

#define II_HOME              327                            /* Cursor keys */
#define II_ARROWUP           328
#define II_PAGEUP            329
#define II_ARROWLEFT         331
#define II_ARROWRIGHT        333
#define II_END               335
#define II_ARROWDOWN         336
#define II_PAGEDOWN          337
#define II_INS               338
#define II_DEL               339

#define II_S_F1              340                  /* Shift-F1 to Shift-F10 */
#define II_S_F2              341
#define II_S_F3              342
#define II_S_F4              343
#define II_S_F5              344
#define II_S_F6              345
#define II_S_F7              346
#define II_S_F8              347
#define II_S_F9              348
#define II_S_F10             349
#define II_S_F11             391                              /* Shift-F11 */
#define II_S_F12             392                              /* Shift-F12 */

#define II_C_F1              350                    /* Ctrl-F1 to Ctrl-F10 */
#define II_C_F2              351
#define II_C_F3              352
#define II_C_F4              353
#define II_C_F5              354
#define II_C_F6              355
#define II_C_F7              356
#define II_C_F8              357
#define II_C_F9              358
#define II_C_F10             359
#define II_C_F11             393                               /* Ctrl-F11 */
#define II_C_F12             394                               /* Ctrl-F12 */

#define II_A_F1              360                      /* Alt-F1 to Alt-F10 */
#define II_A_F2              361
#define II_A_F3              362
#define II_A_F4              363
#define II_A_F5              364
#define II_A_F6              365
#define II_A_F7              366
#define II_A_F8              367
#define II_A_F9              368
#define II_A_F10             369
#define II_A_F11             395                                /* Alt-F11 */
#define II_A_F12             396                                /* Alt-F12 */

#define II_C_PRTSCR          370                      /* Ctrl-Print Screen */

#define II_C_ARROWLEFT       371                      /* Ctrl- cursor keys */
#define II_C_ARROWRIGHT      372
#define II_C_END             373
#define II_C_PAGEDOWN        374
#define II_C_HOME            375
#define II_C_PAGEUP          388

#define II_A_1               376            /* Alt-1/2/3/4/5/6/7/8/9/0/-/= */
#define II_A_2               377
#define II_A_3               378
#define II_A_4               379
#define II_A_5               380
#define II_A_6               381
#define II_A_7               382
#define II_A_8               383
#define II_A_9               384
#define II_A_0               385
#define II_A_MINUS           386
#define II_A_EQUAL           387


/* End Source File ------------------------------------------------------- */

#endif
